/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.internal.tools;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.tools.PointcutExpression;

public class PointcutExpressionImpl
implements PointcutExpression {
    private Pointcut pointcut;
    private String expression;

    public PointcutExpressionImpl(Pointcut pointcut, String expression) {
        this.pointcut = pointcut;
        this.expression = expression;
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesMethodCall(Method aMethod, Class thisClass, Class targetClass, Member withinCode) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("method-call", aMethod, thisClass, targetClass, withinCode));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesMethodExecution(Method aMethod, Class thisClass) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("method-execution", aMethod, thisClass, thisClass, null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesConstructorCall(Constructor aConstructor, Class thisClass, Member withinCode) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("constructor-call", aConstructor, thisClass, aConstructor.getDeclaringClass(), withinCode));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesConstructorExecution(Constructor aConstructor, Class thisClass) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("constructor-execution", aConstructor, thisClass, thisClass, null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesAdviceExecution(Method anAdviceMethod, Class thisClass) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("advice-execution", anAdviceMethod, thisClass, thisClass, null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesHandler(Class exceptionType, Class inClass, Member withinCode) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("exception-handler", new Handler(inClass, exceptionType), inClass, inClass, withinCode));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesInitialization(Constructor aConstructor) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("initialization", aConstructor, aConstructor.getDeclaringClass(), aConstructor.getDeclaringClass(), null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesPreInitialization(Constructor aConstructor) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("preinitialization", aConstructor, aConstructor.getDeclaringClass(), aConstructor.getDeclaringClass(), null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesStaticInitialization(Class aClass) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("staticinitialization", null, aClass, aClass, null));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesFieldSet(Field aField, Class thisClass, Class targetClass, Member withinCode) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("field-set", aField, thisClass, targetClass, withinCode));
    }

    public org.aspectj.weaver.tools.FuzzyBoolean matchesFieldGet(Field aField, Class thisClass, Class targetClass, Member withinCode) {
        return this.fuzzyMatch(this.pointcut.matchesStatically("field-get", aField, thisClass, targetClass, withinCode));
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        return this.pointcut.matchesDynamically(thisObject, targetObject, args);
    }

    public String getPointcutExpression() {
        return this.expression;
    }

    private org.aspectj.weaver.tools.FuzzyBoolean fuzzyMatch(FuzzyBoolean fb) {
        if (fb == FuzzyBoolean.YES) {
            return org.aspectj.weaver.tools.FuzzyBoolean.YES;
        }
        if (fb == FuzzyBoolean.NO) {
            return org.aspectj.weaver.tools.FuzzyBoolean.NO;
        }
        if (fb == FuzzyBoolean.MAYBE) {
            return org.aspectj.weaver.tools.FuzzyBoolean.MAYBE;
        }
        throw new IllegalArgumentException("Cant match FuzzyBoolean " + fb);
    }

    public static class Handler
    implements Member {
        private Class decClass;
        private Class exType;

        public Handler(Class decClass, Class exType) {
            this.decClass = decClass;
            this.exType = exType;
        }

        public int getModifiers() {
            return 0;
        }

        public Class getDeclaringClass() {
            return this.decClass;
        }

        public String getName() {
            return null;
        }

        public Class getHandledExceptionType() {
            return this.exType;
        }

        public boolean isSynthetic() {
            return false;
        }
    }
}

