/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.ITypeParameter;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.Member;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    private void appendTypeParameters(StringBuffer buffer) throws JavaModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        if (length == 0) {
            return;
        }
        buffer.append('<');
        int i = 0;
        while (i < length) {
            ITypeParameter typeParameter = typeParameters[i];
            buffer.append(typeParameter.getElementName());
            String[] bounds = typeParameter.getBounds();
            int boundsLength = bounds.length;
            if (boundsLength > 0) {
                buffer.append(" extends ");
                int j = 0;
                while (j < boundsLength) {
                    buffer.append(bounds[j]);
                    if (j < boundsLength - 1) {
                        buffer.append(" & ");
                    }
                    ++j;
                }
            }
            if (i < length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append('>');
    }

    public String getElementName() {
        return this.name;
    }

    protected String getFullyQualifiedParameterizedName(String fullyQualifiedName, String uniqueKey) throws JavaModelException {
        char[][] typeArguments = Signature.getTypeArguments(uniqueKey.toCharArray());
        int length = typeArguments.length;
        if (length == 0) {
            return fullyQualifiedName;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(fullyQualifiedName);
        buffer.append('<');
        int i = 0;
        while (i < length) {
            char[] typeArgument = typeArguments[i];
            CharOperation.replace(typeArgument, '/', '.');
            buffer.append(Signature.toCharArray(typeArgument));
            if (i < length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    protected IPackageFragment getPackageFragment() {
        return null;
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        NamedMember declaringType;
        switch (this.parent.getElementType()) {
            case 5: {
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(this.name);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return this.name;
            }
            case 6: {
                String classFileName = this.parent.getElementName();
                String typeName = classFileName.indexOf(36) == -1 ? this.name : classFileName.substring(0, classFileName.lastIndexOf(46));
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(typeName);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return typeName;
            }
            case 7: {
                declaringType = (NamedMember)this.parent;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                declaringType = (NamedMember)((Object)((IMember)((Object)this.parent)).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer buffer = new StringBuffer(declaringType.getTypeQualifiedName(enclosingTypeSeparator, showParameters));
        buffer.append(enclosingTypeSeparator);
        String simpleName = this.name.length() == 0 ? Integer.toString(this.occurrenceCount) : this.name;
        buffer.append(simpleName);
        if (showParameters) {
            this.appendTypeParameters(buffer);
        }
        return buffer.toString();
    }

    protected ITypeParameter[] getTypeParameters() throws JavaModelException {
        return null;
    }
}

