/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.fo.flow.TableCell;

public class RowSpanMgr {
    private SpanInfo[] spanInfo;
    private boolean ignoreKeeps = false;

    public RowSpanMgr(int numCols) {
        this.spanInfo = new SpanInfo[numCols];
    }

    public void addRowSpan(TableCell cell, int firstCol, int numCols, int cellHeight, int rowsSpanned) {
        this.spanInfo[firstCol - 1] = new SpanInfo(cell, cellHeight, rowsSpanned);
        int i = 0;
        while (i < numCols - 1) {
            this.spanInfo[firstCol + i] = new SpanInfo(null, cellHeight, rowsSpanned);
            ++i;
        }
    }

    public void finishRow(int rowHeight) {
        int i = 0;
        while (i < this.spanInfo.length) {
            if (this.spanInfo[i] != null && this.spanInfo[i].finishRow(rowHeight)) {
                this.spanInfo[i] = null;
            }
            ++i;
        }
    }

    public int getRemainingHeight(int colNum) {
        if (this.spanInfo[colNum - 1] != null) {
            return this.spanInfo[colNum - 1].heightRemaining();
        }
        return 0;
    }

    public TableCell getSpanningCell(int colNum) {
        if (this.spanInfo[colNum - 1] != null) {
            return this.spanInfo[colNum - 1].cell;
        }
        return null;
    }

    public boolean hasUnfinishedSpans() {
        int i = 0;
        while (i < this.spanInfo.length) {
            if (this.spanInfo[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean ignoreKeeps() {
        return this.ignoreKeeps;
    }

    public boolean isInLastRow(int colNum) {
        if (this.spanInfo[colNum - 1] != null) {
            return this.spanInfo[colNum - 1].isInLastRow();
        }
        return false;
    }

    public boolean isSpanned(int colNum) {
        return this.spanInfo[colNum - 1] != null;
    }

    public void setIgnoreKeeps(boolean ignoreKeeps) {
        this.ignoreKeeps = ignoreKeeps;
    }

    class SpanInfo {
        int cellHeight;
        int totalRowHeight;
        int rowsRemaining;
        TableCell cell;

        SpanInfo(TableCell cell, int cellHeight, int rowsSpanned) {
            this.cell = cell;
            this.cellHeight = cellHeight;
            this.totalRowHeight = 0;
            this.rowsRemaining = rowsSpanned;
        }

        boolean finishRow(int rowHeight) {
            this.totalRowHeight += rowHeight;
            if (--this.rowsRemaining == 0) {
                if (this.cell != null) {
                    this.cell.setRowHeight(this.totalRowHeight);
                }
                return true;
            }
            return false;
        }

        int heightRemaining() {
            int hl = this.cellHeight - this.totalRowHeight;
            return hl > 0 ? hl : 0;
        }

        boolean isInLastRow() {
            return this.rowsRemaining == 1;
        }
    }
}

