/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.UnionEnumeration;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;

public class Key
extends Function {
    private DocumentInfo boundDocument = null;
    private Controller boundController = null;

    public String getName() {
        return "key";
    }

    public int getDataType() {
        return 4;
    }

    public Expression simplify() throws XPathException {
        if (!this.getStaticContext().allowsKeyFunction()) {
            throw new XPathException("key() function cannot be used here");
        }
        this.checkArgumentCount(2, 2);
        this.argument[0] = this.argument[0].simplify();
        this.argument[1] = this.argument[1].simplify();
        return this;
    }

    public Value evaluate(Context context) throws XPathException {
        return new NodeSetExtent(this.enumerate(context), (NodeOrderComparer)LocalOrderComparer.getInstance());
    }

    public NodeEnumeration enumerate(Context context) throws XPathException {
        int n;
        DocumentInfo documentInfo;
        String string = this.argument[0].evaluateAsString(context);
        Value value = this.argument[1].evaluate(context);
        Controller controller = this.boundController;
        if (controller == null) {
            controller = context.getController();
        }
        if ((documentInfo = this.boundDocument) == null) {
            documentInfo = context.getContextNodeInfo().getDocumentRoot();
        }
        if ((n = this.getStaticContext().getFingerprint(string, false)) == -1) {
            throw new XPathException("Key '" + string + "' has not been defined");
        }
        return this.findKey(controller, documentInfo, n, value);
    }

    private NodeEnumeration findKey(Controller controller, DocumentInfo documentInfo, int n, Value value) throws XPathException {
        KeyManager keyManager = controller.getKeyManager();
        if (value instanceof NodeSetValue && !(value instanceof FragmentValue) && !(value instanceof TextFragmentValue)) {
            NodeSetValue nodeSetValue = (NodeSetValue)value;
            NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
            NodeEnumeration nodeEnumeration2 = null;
            int n2 = 0;
            while (nodeEnumeration.hasMoreElements()) {
                NodeEnumeration nodeEnumeration3 = keyManager.selectByKey(n, documentInfo, nodeEnumeration.nextElement().getStringValue(), controller);
                nodeEnumeration2 = ++n2 == 1 ? nodeEnumeration3 : new UnionEnumeration(nodeEnumeration2, nodeEnumeration3, controller);
            }
            if (n2 == 0) {
                return EmptyEnumeration.getInstance();
            }
            return nodeEnumeration2;
        }
        return keyManager.selectByKey(n, documentInfo, value.asString(), controller);
    }

    public int getDependencies() {
        int n = this.argument[0].getDependencies();
        n |= this.argument[1].getDependencies();
        if (this.boundDocument == null) {
            n |= 8;
        }
        if (this.boundController == null) {
            n |= 0x40;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Key key = new Key();
        key.addArgument(this.argument[0].reduce(n, context));
        key.addArgument(this.argument[1].reduce(n, context));
        key.boundDocument = this.boundDocument == null && (n & 8) != 0 ? context.getContextNodeInfo().getDocumentRoot() : this.boundDocument;
        key.boundController = this.boundController == null && (n & 0x40) != 0 ? context.getController() : this.boundController;
        key.setStaticContext(this.getStaticContext());
        return key.simplify();
    }
}

