/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Controller;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
extends ContentEmitter
implements TransformerHandler {
    Controller controller;
    Builder builder;
    Result result;
    String systemId;

    protected TransformerHandlerImpl(Controller controller) {
        this.controller = controller;
        this.setNamePool(controller.getNamePool());
        this.builder = controller.makeBuilder();
        this.builder.setNamePool(controller.getNamePool());
        this.setEmitter(this.builder);
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        DocumentInfo documentInfo = this.builder.getCurrentDocument();
        if (documentInfo == null) {
            throw new SAXException("No source document has been built");
        }
        try {
            this.controller.transformDocument(documentInfo, this.result);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new SAXException(transformerException);
        }
    }
}

