/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;

public abstract class SearchParticipant {
    private IPath lastIndexLocation;

    protected SearchParticipant() {
    }

    public void beginSearching() {
    }

    public void doneSearching() {
    }

    public String getDescription() {
        return "Search participant";
    }

    public abstract SearchDocument getDocument(String var1);

    public abstract void indexDocument(SearchDocument var1, IPath var2);

    public void indexResolvedDocument(SearchDocument document, IPath indexLocation) {
    }

    public abstract void locateMatches(SearchDocument[] var1, SearchPattern var2, IJavaSearchScope var3, SearchRequestor var4, IProgressMonitor var5) throws CoreException;

    public void removeIndex(IPath indexLocation) {
        IndexManager manager = JavaModelManager.getIndexManager();
        manager.removeIndexPath(indexLocation);
    }

    public void resolveDocument(SearchDocument document) {
    }

    public final void scheduleDocumentIndexing(SearchDocument document, IPath indexPath) {
        Path documentPath = new Path(document.getPath());
        Object file = JavaModel.getTarget(documentPath, true);
        IPath containerPath = documentPath;
        if (file instanceof IResource) {
            containerPath = ((IResource)file).getProject().getFullPath();
        } else if (file == null) {
            containerPath = documentPath.removeLastSegments(1);
        }
        IndexManager manager = JavaModelManager.getIndexManager();
        FileIndexLocation indexLocation = new FileIndexLocation(indexPath.toFile(), true);
        manager.ensureIndexExists(indexLocation, containerPath);
        manager.scheduleDocumentIndexing(document, containerPath, indexLocation, this);
        if (!indexPath.equals(this.lastIndexLocation)) {
            manager.updateParticipant(indexPath, containerPath);
            this.lastIndexLocation = indexPath;
        }
    }

    public abstract IPath[] selectIndexes(SearchPattern var1, IJavaSearchScope var2);
}

