/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class AnnotationPointcut
extends NameBindingPointcut {
    private ExactAnnotationTypePattern annotationTypePattern;
    private ShadowMunger munger = null;

    public AnnotationPointcut(ExactAnnotationTypePattern type) {
        this.annotationTypePattern = type;
        this.pointcutKind = (byte)16;
    }

    public AnnotationPointcut(ExactAnnotationTypePattern type, ShadowMunger munger) {
        this(type);
        this.munger = munger;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        if (info.getKind() == Shadow.StaticInitialization) {
            return this.annotationTypePattern.fastMatches(info.getType());
        }
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        AnnotatedElement toMatchAgainst = null;
        Member member = shadow.getSignature();
        ResolvedMember rMember = member.resolve(shadow.getIWorld());
        if (rMember == null) {
            if (member.getName().startsWith("ajc$")) {
                return FuzzyBoolean.NO;
            }
            shadow.getIWorld().getLint().unresolvableMember.signal(member.toString(), this.getSourceLocation());
            return FuzzyBoolean.NO;
        }
        Shadow.Kind kind = shadow.getKind();
        if (kind == Shadow.StaticInitialization) {
            toMatchAgainst = rMember.getDeclaringType().resolve(shadow.getIWorld());
        } else if (kind == Shadow.ExceptionHandler) {
            toMatchAgainst = rMember.getParameterTypes()[0].resolve(shadow.getIWorld());
        } else {
            toMatchAgainst = rMember;
            if (rMember.isAnnotatedElsewhere() && (kind == Shadow.FieldGet || kind == Shadow.FieldSet)) {
                List mungers = rMember.getDeclaringType().resolve(shadow.getIWorld()).getInterTypeMungers();
                Iterator iter = mungers.iterator();
                while (iter.hasNext()) {
                    ResolvedMember rmm;
                    ResolvedMember fakerm;
                    BcelTypeMunger typeMunger = (BcelTypeMunger)iter.next();
                    if (!(typeMunger.getMunger() instanceof NewFieldTypeMunger) || !(fakerm = typeMunger.getSignature()).equals(member)) continue;
                    ResolvedMember ajcMethod = AjcMemberMaker.interFieldInitializer(fakerm, typeMunger.getAspectType());
                    toMatchAgainst = rmm = this.findMethod(typeMunger.getAspectType(), ajcMethod);
                }
            }
        }
        this.annotationTypePattern.resolve(shadow.getIWorld());
        return this.annotationTypePattern.matches(toMatchAgainst);
    }

    private ResolvedMember findMethod(ResolvedTypeX aspectType, ResolvedMember ajcMethod) {
        ResolvedMember[] decMethods = aspectType.getDeclaredMethods();
        for (int i = 0; i < decMethods.length; ++i) {
            ResolvedMember member = decMethods[i];
            if (!member.equals(ajcMethod)) continue;
            return member;
        }
        return null;
    }

    protected void resolveBindings(IScope scope, Bindings bindings) {
        this.annotationTypePattern = (ExactAnnotationTypePattern)this.annotationTypePattern.resolveBindings(scope, bindings, true);
    }

    protected void resolveBindingsFromRTTI() {
    }

    protected Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        ExactAnnotationTypePattern newType = (ExactAnnotationTypePattern)this.annotationTypePattern.remapAdviceFormals(bindings);
        AnnotationPointcut ret = new AnnotationPointcut(newType, bindings.getEnclosingAdvice());
        ret.copyLocationFrom(this);
        return ret;
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            BindingAnnotationTypePattern btp = (BindingAnnotationTypePattern)this.annotationTypePattern;
            TypeX annotationType = btp.annotationType;
            Var var = shadow.getKindedAnnotationVar(annotationType);
            if (var == null) {
                throw new BCException("Impossible! annotation=[" + annotationType + "]  shadow=[" + shadow + " at " + shadow.getSourceLocation() + "]    pointcut is at [" + this.getSourceLocation() + "]");
            }
            if (state.get(btp.getFormalIndex()) != null && this.lastMatchedShadowId == shadow.shadowId) {
                state.setErroneousVar(btp.getFormalIndex());
            }
            state.set(btp.getFormalIndex(), var);
        }
        return Literal.TRUE;
    }

    public List getBindingAnnotationTypePatterns() {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            ArrayList<ExactAnnotationTypePattern> l = new ArrayList<ExactAnnotationTypePattern>();
            l.add(this.annotationTypePattern);
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    public List getBindingTypePatterns() {
        return Collections.EMPTY_LIST;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(16);
        this.annotationTypePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        AnnotationTypePattern type = AnnotationTypePattern.read(s, context);
        AnnotationPointcut ret = new AnnotationPointcut((ExactAnnotationTypePattern)type);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AnnotationPointcut)) {
            return false;
        }
        AnnotationPointcut o = (AnnotationPointcut)other;
        return o.annotationTypePattern.equals(this.annotationTypePattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.annotationTypePattern.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("@annotation(");
        String annPatt = this.annotationTypePattern.toString();
        buf.append(annPatt.startsWith("@") ? annPatt.substring(1) : annPatt);
        buf.append(")");
        return buf.toString();
    }
}

