/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;

public class GVTTreeRenderer
extends Thread {
    protected ImageRenderer renderer;
    protected Shape areaOfInterest;
    protected int width;
    protected int height;
    protected AffineTransform user2DeviceTransform;
    protected boolean doubleBuffering;
    protected List listeners = Collections.synchronizedList(new LinkedList());

    public GVTTreeRenderer(ImageRenderer r, AffineTransform usr2dev, boolean dbuffer, Shape aoi, int width, int height) {
        this.renderer = r;
        this.areaOfInterest = aoi;
        this.user2DeviceTransform = usr2dev;
        this.doubleBuffering = dbuffer;
        this.width = width;
        this.height = height;
    }

    public void run() {
        try {
            this.firePrepareEvent();
            this.renderer.setTransform(this.user2DeviceTransform);
            this.renderer.setDoubleBuffered(this.doubleBuffering);
            this.renderer.updateOffScreen(this.width, this.height);
            this.renderer.clearOffScreen();
            if (this.checkInterrupted()) {
                return;
            }
            this.fireStartedEvent(this.renderer.getOffScreen());
            this.renderer.repaint(this.areaOfInterest);
            if (this.checkInterrupted()) {
                return;
            }
            this.fireCompletedEvent(this.renderer.getOffScreen());
        }
        catch (NoClassDefFoundError e) {
        }
        catch (InterruptedBridgeException e) {
            this.fireFailedEvent();
        }
        catch (InterruptedException e) {
            this.fireFailedEvent();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fireFailedEvent();
        }
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.listeners.remove(l);
    }

    protected boolean checkInterrupted() {
        if (!Thread.interrupted()) {
            return false;
        }
        this.fireCancelledEvent(this.renderer.getOffScreen());
        return true;
    }

    protected void firePrepareEvent() throws InterruptedException {
        block5: {
            final Object[] dll = this.listeners.toArray();
            if (dll.length <= 0) break block5;
            final GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    ((GVTTreeRendererListener)dll[i]).gvtRenderingPrepare(ev);
                    ++i;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < dll.length) {
                                ((GVTTreeRendererListener)dll[i]).gvtRenderingPrepare(ev);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireStartedEvent(BufferedImage bi) throws InterruptedException {
        block5: {
            final Object[] dll = this.listeners.toArray();
            if (dll.length <= 0) break block5;
            final GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, bi);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    ((GVTTreeRendererListener)dll[i]).gvtRenderingStarted(ev);
                    ++i;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int i = 0;
                            while (i < dll.length) {
                                ((GVTTreeRendererListener)dll[i]).gvtRenderingStarted(ev);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCancelledEvent(BufferedImage bi) {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, bi);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    ((GVTTreeRendererListener)dll[i]).gvtRenderingCancelled(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            ((GVTTreeRendererListener)dll[i]).gvtRenderingCancelled(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireCompletedEvent(BufferedImage bi) {
        final Object[] dll = this.listeners.toArray();
        if (dll.length > 0) {
            final GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, bi);
            if (EventQueue.isDispatchThread()) {
                int i = 0;
                while (i < dll.length) {
                    ((GVTTreeRendererListener)dll[i]).gvtRenderingCompleted(ev);
                    ++i;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < dll.length) {
                            ((GVTTreeRendererListener)dll[i]).gvtRenderingCompleted(ev);
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        int count = 10;
        while (--count != 0) {
            block6: {
                try {
                    final Object[] dll = this.listeners.toArray();
                    if (dll.length <= 0) break block6;
                    final GVTTreeRendererEvent ev = new GVTTreeRendererEvent(this, null);
                    if (EventQueue.isDispatchThread()) {
                        int i = 0;
                        while (i < dll.length) {
                            ((GVTTreeRendererListener)dll[i]).gvtRenderingFailed(ev);
                            ++i;
                        }
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                int i = 0;
                                while (i < dll.length) {
                                    ((GVTTreeRendererListener)dll[i]).gvtRenderingFailed(ev);
                                    ++i;
                                }
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    continue;
                }
            }
            return;
        }
    }
}

