/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;

public class AWTEventDispatcher
implements EventDispatcher,
MouseListener,
MouseMotionListener,
KeyListener {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode dummyNode = new TextNode();
    protected GraphicsNode currentKeyEventTarget;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 1;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeKeyListener;

    public void setRootNode(GraphicsNode root) {
        this.root = root;
    }

    public GraphicsNode getRootNode() {
        return this.root;
    }

    public void setBaseTransform(AffineTransform t) {
        this.baseTransform = t;
    }

    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    public void mousePressed(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyPressed(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyReleased(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void keyTyped(KeyEvent evt) {
        this.dispatchEvent(evt);
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener l) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, l);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener l) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, l);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener l) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, l);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener l) {
        if (this.glisteners != null) {
            this.glisteners.remove(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, l);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        Object array = Array.newInstance(listenerType, this.glisteners.getListenerCount(listenerType));
        Object[] pairElements = this.glisteners.getListenerList();
        int i = 0;
        int j = 0;
        while (i < pairElements.length - 1) {
            if (pairElements[i].equals(listenerType)) {
                Array.set(array, j, pairElements[i + 1]);
                ++j;
            }
            i += 2;
        }
        return (EventListener[])array;
    }

    public void dispatchEvent(EventObject evt) {
        if (this.root == null) {
            return;
        }
        if (evt instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)evt);
        } else if (evt instanceof KeyEvent) {
            InputEvent e = (InputEvent)evt;
            if (this.isNodeIncrementEvent(e)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(e)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)evt);
            }
        }
    }

    protected void dispatchKeyEvent(KeyEvent evt) {
        this.currentKeyEventTarget = this.lastHit;
        if (this.currentKeyEventTarget != null) {
            this.processKeyEvent(new GraphicsNodeKeyEvent(this.currentKeyEventTarget, evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar()));
        }
    }

    protected void dispatchMouseEvent(MouseEvent evt) {
        GraphicsNodeMouseEvent gvtevt;
        Point2D p = new Point2D.Float(evt.getX(), evt.getY());
        if (this.baseTransform != null) {
            p = this.baseTransform.transform(p, null);
        }
        GraphicsNode node = this.root.nodeHitAt(p);
        Point screenPos = evt.getComponent().getLocationOnScreen();
        screenPos.x += evt.getX();
        screenPos.y += evt.getY();
        if (this.lastHit != node) {
            if (this.lastHit != null) {
                gvtevt = new GraphicsNodeMouseEvent(this.lastHit, 505, evt.getWhen(), evt.getModifiers(), (float)p.getX(), (float)p.getY(), screenPos.x, screenPos.y, evt.getClickCount(), node);
                this.processMouseEvent(gvtevt);
            }
            if (node != null) {
                gvtevt = new GraphicsNodeMouseEvent(node, 504, evt.getWhen(), evt.getModifiers(), (float)p.getX(), (float)p.getY(), screenPos.x, screenPos.y, evt.getClickCount(), this.lastHit);
                this.processMouseEvent(gvtevt);
            }
        }
        if (node != null) {
            gvtevt = new GraphicsNodeMouseEvent(node, evt.getID(), evt.getWhen(), evt.getModifiers(), (float)p.getX(), (float)p.getY(), screenPos.x, screenPos.y, evt.getClickCount(), null);
            this.processMouseEvent(gvtevt);
        } else if (node == null && evt.getID() == 500 && evt.getClickCount() == 1) {
            gvtevt = new GraphicsNodeMouseEvent(this.dummyNode, evt.getID(), evt.getWhen(), evt.getModifiers(), (float)p.getX(), (float)p.getY(), screenPos.x, screenPos.y, evt.getClickCount(), null);
            this.processMouseEvent(gvtevt);
        }
        this.lastHit = node;
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent evt) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] listeners = (GraphicsNodeMouseListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener);
            switch (evt.getID()) {
                case 503: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseMoved(evt);
                        ++i;
                    }
                    break;
                }
                case 506: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseDragged(evt);
                        ++i;
                    }
                    break;
                }
                case 504: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseEntered(evt);
                        ++i;
                    }
                    break;
                }
                case 505: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseExited(evt);
                        ++i;
                    }
                    break;
                }
                case 500: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseClicked(evt);
                        ++i;
                    }
                    break;
                }
                case 501: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mousePressed(evt);
                        ++i;
                    }
                    break;
                }
                case 502: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].mouseReleased(evt);
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Mouse Event type: " + evt.getID());
                }
            }
        }
    }

    public void processKeyEvent(GraphicsNodeKeyEvent evt) {
        if (this.glisteners != null) {
            GraphicsNodeKeyListener[] listeners = (GraphicsNodeKeyListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AWTEventDispatcher.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener);
            switch (evt.getID()) {
                case 401: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].keyPressed(evt);
                        ++i;
                    }
                    break;
                }
                case 402: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].keyReleased(evt);
                        ++i;
                    }
                    break;
                }
                case 400: {
                    int i = 0;
                    while (i < listeners.length) {
                        listeners[i].keyTyped(evt);
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Key Event type: " + evt.getID());
                }
            }
        }
        evt.consume();
    }

    private void incrementKeyTarget() {
        throw new Error("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new Error("Decrement not implemented.");
    }

    public void setNodeIncrementEvent(InputEvent e) {
        this.nodeIncrementEventID = e.getID();
        if (e instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)e).getKeyCode();
        }
        this.nodeIncrementEventModifiers = e.getModifiers();
    }

    public void setNodeDecrementEvent(InputEvent e) {
        this.nodeDecrementEventID = e.getID();
        if (e instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)e).getKeyCode();
        }
        this.nodeDecrementEventModifiers = e.getModifiers();
    }

    protected boolean isNodeIncrementEvent(InputEvent e) {
        return e.getID() == this.nodeIncrementEventID && (!(e instanceof KeyEvent) || ((KeyEvent)e).getKeyCode() == this.nodeIncrementEventCode) && (e.getModifiers() & this.nodeIncrementEventModifiers) != 0;
    }

    protected boolean isNodeDecrementEvent(InputEvent e) {
        return e.getID() == this.nodeDecrementEventID && (!(e instanceof KeyEvent) || ((KeyEvent)e).getKeyCode() == this.nodeDecrementEventCode) && (e.getModifiers() & this.nodeDecrementEventModifiers) != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

