/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractImageZoomInteractor
extends InteractorAdapter {
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent e) {
        if (!this.finished) {
            JGVTComponent c = (JGVTComponent)e.getSource();
            c.setPaintingTransform(null);
            return;
        }
        this.finished = false;
        this.xStart = e.getX();
        this.yStart = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e.getSource();
        AffineTransform pt = c.getPaintingTransform();
        if (pt != null) {
            AffineTransform rt = (AffineTransform)c.getRenderingTransform().clone();
            rt.preConcatenate(pt);
            c.setRenderingTransform(rt);
        }
    }

    public void mouseDragged(MouseEvent e) {
        JGVTComponent c = (JGVTComponent)e.getSource();
        this.xCurrent = e.getX();
        this.yCurrent = e.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xStart, this.yStart);
        int dy = this.yCurrent - this.yStart;
        dy = dy < 0 ? (dy > -5 ? 15 : dy - 10) : (dy < 5 ? 15 : dy + 10);
        double s = (double)dy / 15.0;
        s = s > 0.0 ? s : -1.0 / s;
        at.scale(s, s);
        at.translate(-this.xStart, -this.yStart);
        c.setPaintingTransform(at);
    }
}

