/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.ILocalVariable;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.LambdaExpression;
import org.aspectj.org.eclipse.jdt.internal.core.LocalVariable;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethod;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;

public class LambdaMethod
extends SourceMethod {
    private int sourceStart;
    private String[] parameterNameStrings;
    private String returnTypeString;
    SourceMethodElementInfo elementInfo;
    private String key;

    LambdaMethod(JavaElement parent, String name, String key, int sourceStart, String[] parameterTypes, String[] parameterNames, String returnType, SourceMethodElementInfo elementInfo) {
        super(parent, name, parameterTypes);
        this.sourceStart = sourceStart;
        this.parameterNameStrings = parameterNames;
        this.returnTypeString = returnType;
        this.elementInfo = elementInfo;
        this.key = key;
    }

    @Override
    public String getReturnType() throws JavaModelException {
        return this.returnTypeString;
    }

    @Override
    public String getSignature() throws JavaModelException {
        return Signature.createMethodSignature(this.parameterTypes, this.returnTypeString);
    }

    @Override
    public boolean isLambdaMethod() {
        return true;
    }

    @Override
    protected void closing(Object info) {
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LambdaMethod)) {
            return false;
        }
        LambdaMethod that = (LambdaMethod)o;
        return super.equals(o) && this.sourceStart == that.sourceStart;
    }

    @Override
    public Object getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        return this.elementInfo;
    }

    public void getHandleMemento(StringBuffer buff, boolean serializeParent) {
        if (serializeParent) {
            ((LambdaExpression)this.getParent()).getHandleMemento(buff, true, false);
        }
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
        buff.append('!');
        buff.append(this.parameterTypes.length);
        int i = 0;
        int length = this.parameterTypes.length;
        while (i < length) {
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterTypes[i]);
            this.appendEscapedDelimiter(buff, '\"');
            this.escapeMementoName(buff, this.parameterNameStrings[i]);
            ++i;
        }
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.returnTypeString);
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.key);
        ILocalVariable[] arguments = this.elementInfo.arguments;
        int i2 = 0;
        int length2 = arguments.length;
        while (i2 < length2) {
            LocalVariable local = (LocalVariable)arguments[i2];
            local.getHandleMemento(buff, false);
            ++i2;
        }
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        this.getHandleMemento(buff, true);
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '&';
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(super.hashCode(), this.sourceStart);
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public JavaElement resolved(Binding binding) {
        return this;
    }
}

