/*
 * Decompiled with CFR 0.152.
 */
package com.bar;

import com.foobar.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.spi.LocaleNameProvider;

public class LocaleNameProviderImpl
extends LocaleNameProvider {
    static Locale[] avail = new Locale[]{Locale.JAPANESE, Locale.JAPAN, new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), new Locale("xx"), new Locale("yy", "YY", "YYYY")};
    static List<Locale> availList = Arrays.asList(avail);

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public String getDisplayLanguage(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    @Override
    public String getDisplayCountry(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    @Override
    public String getDisplayVariant(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    private String getDisplayString(String string, Locale locale) {
        if (!Utils.supportsLocale(availList, locale)) {
            throw new IllegalArgumentException("locale is not supported: " + locale);
        }
        String string2 = null;
        if (locale.getLanguage().equals("yy") && locale.getCountry().equals("YY")) {
            String string3 = locale.getVariant();
            if (string3.startsWith("YYYY")) {
                switch (string) {
                    case "yy": 
                    case "YY": {
                        string2 = "waiwai";
                        break;
                    }
                    case "YYYY": {
                        if (string3.equals("YYYY_suffix")) {
                            throw new RuntimeException(string3);
                        }
                        string2 = "waiwai";
                    }
                }
            }
        } else {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.bar.LocaleNames", locale);
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }
}

