/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for {@link org.eclipse.collections.api.multimap.sortedbag.SortedBagMultimap}.
 * <p>
 *     A SortedBagMultimap is a type of {@link org.eclipse.collections.api.multimap.Multimap} that stores the values for keys in a {@link org.eclipse.collections.api.bag.sorted.MutableSortedBag}.
 * <p>
 * This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.sortedbag.SortedBagMultimap} - A Read-only Sorted Bag Multimap API.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.sortedbag.MutableSortedBagMultimap} - Modifiable Sorted Bag multimap.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap} - Non-modifiable equivalent interface to {@link org.eclipse.collections.api.multimap.sortedbag.MutableSortedBagMultimap}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.multimap.sortedbag;
