/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.StringUtil;

public class ErrorHandler
extends AbstractHandler {
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException {
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
        HttpConnection connection = HttpConnection.getCurrentConnection();
        this.handleErrorPage(request, writer, connection.getResponse().getStatus(), connection.getResponse().getReason());
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo((OutputStream)response.getOutputStream());
        writer.destroy();
        return true;
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        ErrorHandler.writeErrorPage(request, writer, code, message);
    }

    public static void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        if (message != null) {
            message = URLDecoder.decode(message, "UTF-8");
            message = StringUtil.replace(message, "<", "&lt;");
            message = StringUtil.replace(message, ">", "&gt;");
        }
        String uri = request.getRequestURI();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<html>\n<head>\n<title>Error ");
        writer.write(Integer.toString(code));
        writer.write(32);
        if (message == null) {
            message = "" + code;
        }
        writer.write(message);
        writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
        writer.write(Integer.toString(code));
        writer.write("</h2><pre>");
        writer.write(message);
        writer.write("</pre>\n");
        writer.write("<p>RequestURI=");
        writer.write(uri);
        writer.write("</p>\n<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by Jetty://</a></small></i></p>");
        for (int i = 0; i < 20; ++i) {
            writer.write("\n                                                ");
        }
        writer.write("\n</body>\n</html>\n");
    }
}

