/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;

    public void open() throws IOException {
        this._serverSocket = this.newServerSocket(this.getAddress(), this.getAcceptQueueSize());
    }

    protected ServerSocket newServerSocket(SocketAddress addr, int backlog) throws IOException {
        ServerSocket ss = new ServerSocket();
        ss.bind(addr, backlog);
        return ss;
    }

    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        this.configure((Socket)endpoint.getConnection());
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched = false;
        HttpConnection _connection;

        public Connection(Socket socket) throws IOException {
            super(socket);
            this._connection = new HttpConnection(SocketConnector.this, this, SocketConnector.this.getServer());
        }

        public void dispatch() throws InterruptedException, IOException {
            if (!SocketConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for {}", this._connection);
                this.close();
            }
        }

        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.isClosed()) {
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug("EOF", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (HttpException e) {
                Log.debug("BAD", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (Throwable e) {
                Log.warn("handle failed", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
        }
    }
}

