---
title: File Types
layout: documentation
---
# File Types

There are many file types in WiX that are generated from different tools in the toolset. At the highest level, all input files and intermediate files for WiX are XML files. The
final output is in the form of standard Windows Installer database files.

For example, to build an MSI or MSP, the compiler processes the source files
(.wxs and .wxi) and produces object files (.wixobj). These objects files are then consumed by the linker, which produces Windows Installer database files (.msi or .msm). This is analogous to the C++ model of compiling source code to object files, then linking to produce executables.

## List of file types

The following list describes the supported file types in WiX:

<table border="1" cellpadding="5%">
  <tr>
    <td><b>Extension</b></td>
    <td><b>Type</b></td>
    <td><b>Description</b></td>
  </tr>
  <tr>
    <td>
      <p>.wxi</p>
    </td>
    <td>
      <p>WiX Include File</p>
    </td>
    <td>
      <p>A .wxi file is analogous to .h files for C++. The root element of this file is &lt;Include&gt;. Everything under the root element will be inserted inline when this file is included in another source or include file.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wxl</p>
    </td>
    <td>
      <p>WiX Localization File</p>
    </td>
    <td>
      <p>A .wxl file contains a set of strings used for localizing a product into a specified culture. The root element of this file is &lt;WixLocalization&gt;. The culture is specified by setting the Culture attribute on the &lt;WixLocalization&gt; element.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wxs</p>
    </td>
    <td>
      <p>WiX Source File</p>
    </td>
    <td>
      <p>A .wxs file is analogous to a .cpp file for C++. The Root element of this file is &lt;Wix&gt;. 
          For more detail, see Additional Information below.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixobj</p>
    </td>
    <td>
      <p>WiX Object File</p>
    </td>
    <td>
      <p>A .wixobj file is created by the compiler for each source file compiled. The .wixobj file contains one or more sections that, in turn, contain symbols and references to other symbols. 
          For more detail, see Additional Information below.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixout</p>
    </td>
    <td>
      <p>WiX XML Output File</p>
    </td>
    <td>
      <p>A .wixout file is created by the linker which represents the result of linking a set of object files. The .wixout is an XML representation of the final output.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixlib</p>
    </td>
    <td>
      <p>WiX Library File</p>
    </td>
    <td>
      <p>A .wixlib file is a library of setup functionality that can be easily shared across different WiX-based packages by including it when linking the setup package.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixpdb</p>
    </td>
    <td>
      <p>WiX Debug File</p>
    </td>
    <td>
      <p>A .wixpdb file is created by the linker for each final output. It contains the debugging information.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixmsp</p>
    </td>
    <td>
      <p>WiX XML Patch File</p>
    </td>
    <td>
      <p>A .wixmsp file is the XML output generated by linking object files in a patch build.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.wixmst</p>
    </td>
    <td>
      <p>WiX Transform File</p>
    </td>
    <td>
      <p>A .wixmst file is an XML representation of the difference between a pair of final outputs or XML outputs.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.msi</p>
    </td>
    <td>
      <p>Windows Installer Installation Package</p>
    </td>
    <td>
      <p>An installation package file (.msi) is the basic unit of installation for the 
          Windows Installer. </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.msm</p>
    </td>
    <td>
      <p>Windows Installer Merge Module</p>
    </td>
    <td>
      <p>A merge module file (.msm) is used to share setup logic across different .msi 
          packages. A merge module can be created by one development team, then merged 
          into another development team&#39;s .msi package.</p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.mst</p>
    </td>
    <td>
      <p>Windows Installer Transform</p>
    </td>
    <td>
      <p>A transform file (.mst) is used to apply changes to an .msi file. </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>.pcp</p>
    </td>
    <td>
      <p>Windows Installer Patch Creation Process</p>
    </td>
    <td>
      <p>A patch creation properties file (.pcp) is used as an input to the patch building 
          tools provided in the Windows Installer SDK. </p>
    </td>
  </tr>
</table>

## Additional Information

###Structure of .wxs files

All .wxs files are well-formed XML documents that contain a single root element named &lt;Wix/&gt;. The rest of the source file may or may not adhere to the WiX schema before preprocessing. However, after being preprocessed all source files must conform to the WiX schema or they will fail to compile.

The root &lt;Wix&gt; element can contain at most one of the following elements as children: &lt;Product&gt;, &lt;Module&gt;, and &lt;Patch&gt;. However, there can be an unbounded number &lt;Fragment&gt; elements as children of the root &lt;Wix&gt; element. When a source file is compiled into an object file, each instance of these elements creates a new section in the object file. Therefore, these three elements are often referred to as section elements.

It is important to note, that there can be only one &lt;Product&gt; or &lt;Module&gt; or &lt;Patch&gt; section element per source file because they are compiled into special sections called entry sections. Entry sections are used as starting points in the linking process. Sections, entry sections, and the entire linking process are described in greater detail later in this document.

The children of the section elements define the contents of the Windows Installer database. You&rsquo;ll recognize &lt;Property&gt; elements that map to entries in the Property table and a hierarchy of &lt;Directory&gt; elements that build up the Directory table. Most elements contain an &ldquo;Id&rdquo; attribute that will act as the primary key for the resulting row in the Windows Installer database. In most cases, the &ldquo;Id&rdquo; attribute also defines a symbol when the source file is compiled into an object file.

### Symbols and references

Every symbol in an object file is composed of the element name plus the unique identifier from the &ldquo;Id&rdquo; attribute. Symbols are important because they can be referenced by other sections from any source file. For example, a &lt;Directory&gt; structure can be defined in a &lt;Fragment&gt; in one source file and a &lt;Component&gt; can be defined under a different source file&rsquo;s &lt;Fragment&gt;. By making the &lt;DirectoryRef&gt; element a parent of the &lt;Component&gt; an explicit reference is created that references the symbol defined by a &lt;Directory&gt; in the first source file. The linker is then responsible for stitching the symbol and the reference together in a single Windows Installer database. In some cases, implicit references are generated by the compiler while processing a source file. These implicit references behave identically to explicit references.

In addition to the simple references described above, WiX supports specific complex references. Complex references are used in cases where the linker must generate extra information to link the symbol and reference together. The perfect example of a complex reference is in the Windows Installer&rsquo;s Feature/Component relationship. When a &lt;Component&gt; is referenced explicitly by a &lt;Feature&gt; through a &lt;ComponentRef&gt; element, the linker must take the &lt;Feature&gt;&rsquo;s symbol and the &lt;Component&gt;&rsquo;s symbol and add an entry to the FeatureComponents table.

This Feature/Component relationship is even more complex because certain elements in a &lt;Component&gt;, for example &lt;Shortcut&gt;, have references back to the primary Feature associated with the Component. These references from a child element of a &lt;Component&gt; are called reverse references or sometimes feature backlinks. Processing complex references and reverse references is probably the most difficult work the linker has to do.

### Structure of the .wixobj file

A .wixobj file is created by the compiler for each source file compiled. The .wixobj file is an XML document that follows the objects.xsd schema defined in the WiX project. As stated above the .wixobj file contains one or more sections that, in turn, contain symbols and references to other symbols.

While the symbols and references are arguably the most important pieces of data in the .wixobj file, they are rarely the bulk of the information. Instead, most .wixobj files are composed of &lt;table&gt;, &lt;row&gt; and &lt;field&gt; elements that provide the raw data to be placed in the Windows Installer database. In many cases, the linker will not only process the symbols and references but also use and update the raw data from the .wixobj file. It is interesting to note that the object file schema, objects.xsd, uses camel casing where the source file schema, wix.xsd, uses Pascal casing. This was a conscious choice to indicate that the object files are not intended to be edited by the user. In fact, all schemas that define data to be processed only by the WiX tools use camel casing.
