---
title: How To Guides
layout: documentation
after: /bundle/
---
# How To Guides

This section includes How To documentation for performing common WiX tasks.

## Files, Shortcuts and Registry

* [Add a file to your installer](files_and_registry/add_a_file.html)
* [Check the version number of a file during installation](files_and_registry/check_the_version_number.html)
* [Write a registry entry during installation](files_and_registry/write_a_registry_entry.html)
* [Read a registry entry during installation](files_and_registry/read_a_registry_entry.html)
* [Create a shortcut on the Start Menu](files_and_registry/create_start_menu_shortcut.html)
* [Create a shortcut to a web page](files_and_registry/create_internet_shortcut.html)
* [Create an uninstall shortcut](files_and_registry/create_uninstall_shortcut.html)
* [NGen managed assemblies during installation](files_and_registry/ngen_managed_assemblies.html)
* [Reference another DirectorySearch element](files_and_registry/directorysearchref.html)
* [Get the parent directory of a file search](files_and_registry/parentdirectorysearch.html)

## Redistributables and Install Checks

* [Check for .NET Framework versions](redistributables_and_install_checks/check_for_dotnet.html)
* [Install the .NET Framework using a bootstrapper](redistributables_and_install_checks/install_dotnet.html)
* [Install DirectX 9.0 with your installer](redistributables_and_install_checks/install_directx9.html)
* [Install the Visual C++ Redistributable with your installer](redistributables_and_install_checks/install_vcredist.html)
* [Block installation based on OS version](redistributables_and_install_checks/block_install_on_os.html)

## User Interface and Localization

* [Build a localized version of your installer](ui_and_localization/build_a_localized_version.html)
* [Make your installer localizable](ui_and_localization/make_installer_localizable.html)
* [Run the installed application after setup](ui_and_localization/run_program_after_install.html)
* [Set your installer&apos;s icon in Add/Remove Programs](ui_and_localization/configure_arp_appearance.html)

## Product Updates

* [Implement a major upgrade in your installer](updates/major_upgrade.html)

## Others

* [Get a log of your installation for debugging](general/get_a_log.html)
* [Look inside your MSI with Orca](general/look_inside_msi.html)
* [Generate a GUID](general/generate_guids.html)
* [Use WiX Extensions](general/extension_usage_introduction.html)
* [Optimize building cabinet files](general/optimizing_builds.html)
* [Specify source file locations](general/specifying_source_files.html)
