// Copyright (c) .NET Foundation and contributors. All rights reserved. Licensed under the Microsoft Reciprocal License. See LICENSE.TXT file in the project root for full license information.

int InvokeCustomAction(MSIHANDLE hSession,
	const wchar_t* szWorkingDir, const wchar_t* szEntryPoint);

/// <summary>
/// Macro for defining and exporting a custom action entrypoint.
/// </summary>
/// <param name="name">Name of the entrypoint as exported from
/// the DLL.</param>
/// <param name="method">Path to the managed custom action method,
/// in the form: "AssemblyName!Namespace.Class.Method"</param>
/// <remarks>
/// To prevent the exported name from being decorated, add
/// /EXPORT:name to the linker options for every entrypoint.
/// </remarks>
#define CUSTOMACTION_ENTRYPOINT(name,method) extern "C" int __stdcall \
	name(MSIHANDLE hSession) { return InvokeCustomAction(hSession, NULL, method); }

// TEMPLATE ENTRYPOINTS
// To be edited by the MakeSfxCA tool.

#define NULLSPACE \
L"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0" \
L"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0" \
L"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0" \
L"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"

#define TEMPLATE_CA_ENTRYPOINT(id,sid) CUSTOMACTION_ENTRYPOINT( \
	CustomActionEntryPoint##id##, \
	L"CustomActionEntryPoint" sid NULLSPACE)

TEMPLATE_CA_ENTRYPOINT(000,L"000");
TEMPLATE_CA_ENTRYPOINT(001,L"001");
TEMPLATE_CA_ENTRYPOINT(002,L"002");
TEMPLATE_CA_ENTRYPOINT(003,L"003");
TEMPLATE_CA_ENTRYPOINT(004,L"004");
TEMPLATE_CA_ENTRYPOINT(005,L"005");
TEMPLATE_CA_ENTRYPOINT(006,L"006");
TEMPLATE_CA_ENTRYPOINT(007,L"007");
TEMPLATE_CA_ENTRYPOINT(008,L"008");
TEMPLATE_CA_ENTRYPOINT(009,L"009");
TEMPLATE_CA_ENTRYPOINT(010,L"010");
TEMPLATE_CA_ENTRYPOINT(011,L"011");
TEMPLATE_CA_ENTRYPOINT(012,L"012");
TEMPLATE_CA_ENTRYPOINT(013,L"013");
TEMPLATE_CA_ENTRYPOINT(014,L"014");
TEMPLATE_CA_ENTRYPOINT(015,L"015");
TEMPLATE_CA_ENTRYPOINT(016,L"016");
TEMPLATE_CA_ENTRYPOINT(017,L"017");
TEMPLATE_CA_ENTRYPOINT(018,L"018");
TEMPLATE_CA_ENTRYPOINT(019,L"019");
TEMPLATE_CA_ENTRYPOINT(020,L"020");
TEMPLATE_CA_ENTRYPOINT(021,L"021");
TEMPLATE_CA_ENTRYPOINT(022,L"022");
TEMPLATE_CA_ENTRYPOINT(023,L"023");
TEMPLATE_CA_ENTRYPOINT(024,L"024");
TEMPLATE_CA_ENTRYPOINT(025,L"025");
TEMPLATE_CA_ENTRYPOINT(026,L"026");
TEMPLATE_CA_ENTRYPOINT(027,L"027");
TEMPLATE_CA_ENTRYPOINT(028,L"028");
TEMPLATE_CA_ENTRYPOINT(029,L"029");
TEMPLATE_CA_ENTRYPOINT(030,L"030");
TEMPLATE_CA_ENTRYPOINT(031,L"031");
TEMPLATE_CA_ENTRYPOINT(032,L"032");
TEMPLATE_CA_ENTRYPOINT(033,L"033");
TEMPLATE_CA_ENTRYPOINT(034,L"034");
TEMPLATE_CA_ENTRYPOINT(035,L"035");
TEMPLATE_CA_ENTRYPOINT(036,L"036");
TEMPLATE_CA_ENTRYPOINT(037,L"037");
TEMPLATE_CA_ENTRYPOINT(038,L"038");
TEMPLATE_CA_ENTRYPOINT(039,L"039");
TEMPLATE_CA_ENTRYPOINT(040,L"040");
TEMPLATE_CA_ENTRYPOINT(041,L"041");
TEMPLATE_CA_ENTRYPOINT(042,L"042");
TEMPLATE_CA_ENTRYPOINT(043,L"043");
TEMPLATE_CA_ENTRYPOINT(044,L"044");
TEMPLATE_CA_ENTRYPOINT(045,L"045");
TEMPLATE_CA_ENTRYPOINT(046,L"046");
TEMPLATE_CA_ENTRYPOINT(047,L"047");
TEMPLATE_CA_ENTRYPOINT(048,L"048");
TEMPLATE_CA_ENTRYPOINT(049,L"049");
TEMPLATE_CA_ENTRYPOINT(050,L"050");
TEMPLATE_CA_ENTRYPOINT(051,L"051");
TEMPLATE_CA_ENTRYPOINT(052,L"052");
TEMPLATE_CA_ENTRYPOINT(053,L"053");
TEMPLATE_CA_ENTRYPOINT(054,L"054");
TEMPLATE_CA_ENTRYPOINT(055,L"055");
TEMPLATE_CA_ENTRYPOINT(056,L"056");
TEMPLATE_CA_ENTRYPOINT(057,L"057");
TEMPLATE_CA_ENTRYPOINT(058,L"058");
TEMPLATE_CA_ENTRYPOINT(059,L"059");
TEMPLATE_CA_ENTRYPOINT(060,L"060");
TEMPLATE_CA_ENTRYPOINT(061,L"061");
TEMPLATE_CA_ENTRYPOINT(062,L"062");
TEMPLATE_CA_ENTRYPOINT(063,L"063");
TEMPLATE_CA_ENTRYPOINT(064,L"064");
TEMPLATE_CA_ENTRYPOINT(065,L"065");
TEMPLATE_CA_ENTRYPOINT(066,L"066");
TEMPLATE_CA_ENTRYPOINT(067,L"067");
TEMPLATE_CA_ENTRYPOINT(068,L"068");
TEMPLATE_CA_ENTRYPOINT(069,L"069");
TEMPLATE_CA_ENTRYPOINT(070,L"070");
TEMPLATE_CA_ENTRYPOINT(071,L"071");
TEMPLATE_CA_ENTRYPOINT(072,L"072");
TEMPLATE_CA_ENTRYPOINT(073,L"073");
TEMPLATE_CA_ENTRYPOINT(074,L"074");
TEMPLATE_CA_ENTRYPOINT(075,L"075");
TEMPLATE_CA_ENTRYPOINT(076,L"076");
TEMPLATE_CA_ENTRYPOINT(077,L"077");
TEMPLATE_CA_ENTRYPOINT(078,L"078");
TEMPLATE_CA_ENTRYPOINT(079,L"079");
TEMPLATE_CA_ENTRYPOINT(080,L"080");
TEMPLATE_CA_ENTRYPOINT(081,L"081");
TEMPLATE_CA_ENTRYPOINT(082,L"082");
TEMPLATE_CA_ENTRYPOINT(083,L"083");
TEMPLATE_CA_ENTRYPOINT(084,L"084");
TEMPLATE_CA_ENTRYPOINT(085,L"085");
TEMPLATE_CA_ENTRYPOINT(086,L"086");
TEMPLATE_CA_ENTRYPOINT(087,L"087");
TEMPLATE_CA_ENTRYPOINT(088,L"088");
TEMPLATE_CA_ENTRYPOINT(089,L"089");
TEMPLATE_CA_ENTRYPOINT(090,L"090");
TEMPLATE_CA_ENTRYPOINT(091,L"091");
TEMPLATE_CA_ENTRYPOINT(092,L"092");
TEMPLATE_CA_ENTRYPOINT(093,L"093");
TEMPLATE_CA_ENTRYPOINT(094,L"094");
TEMPLATE_CA_ENTRYPOINT(095,L"095");
TEMPLATE_CA_ENTRYPOINT(096,L"096");
TEMPLATE_CA_ENTRYPOINT(097,L"097");
TEMPLATE_CA_ENTRYPOINT(098,L"098");
TEMPLATE_CA_ENTRYPOINT(099,L"099");
TEMPLATE_CA_ENTRYPOINT(100,L"100");
TEMPLATE_CA_ENTRYPOINT(101,L"101");
TEMPLATE_CA_ENTRYPOINT(102,L"102");
TEMPLATE_CA_ENTRYPOINT(103,L"103");
TEMPLATE_CA_ENTRYPOINT(104,L"104");
TEMPLATE_CA_ENTRYPOINT(105,L"105");
TEMPLATE_CA_ENTRYPOINT(106,L"106");
TEMPLATE_CA_ENTRYPOINT(107,L"107");
TEMPLATE_CA_ENTRYPOINT(108,L"108");
TEMPLATE_CA_ENTRYPOINT(109,L"109");
TEMPLATE_CA_ENTRYPOINT(110,L"110");
TEMPLATE_CA_ENTRYPOINT(111,L"111");
TEMPLATE_CA_ENTRYPOINT(112,L"112");
TEMPLATE_CA_ENTRYPOINT(113,L"113");
TEMPLATE_CA_ENTRYPOINT(114,L"114");
TEMPLATE_CA_ENTRYPOINT(115,L"115");
TEMPLATE_CA_ENTRYPOINT(116,L"116");
TEMPLATE_CA_ENTRYPOINT(117,L"117");
TEMPLATE_CA_ENTRYPOINT(118,L"118");
TEMPLATE_CA_ENTRYPOINT(119,L"119");
TEMPLATE_CA_ENTRYPOINT(120,L"120");
TEMPLATE_CA_ENTRYPOINT(121,L"121");
TEMPLATE_CA_ENTRYPOINT(122,L"122");
TEMPLATE_CA_ENTRYPOINT(123,L"123");
TEMPLATE_CA_ENTRYPOINT(124,L"124");
TEMPLATE_CA_ENTRYPOINT(125,L"125");
TEMPLATE_CA_ENTRYPOINT(126,L"126");
TEMPLATE_CA_ENTRYPOINT(127,L"127");

// Note: Keep in sync with EntryPoints.def
