/* *******************************************************************
 * Copyright (c) 2004 IBM Corporation
 * All rights reserved.
 * This program and the accompanying materials are made available
 * under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution and is available at
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * ******************************************************************/
package org.aspectj.systemtest.ajc10x;

import java.io.File;

import junit.framework.Test;

import org.aspectj.testing.XMLBasedAjcTestCase;

public class Ajc10xTests extends org.aspectj.testing.XMLBasedAjcTestCase {

	public static Test suite() {
		return XMLBasedAjcTestCase.loadSuite(Ajc10xTests.class);
	}

	@Override
	protected File getSpecFile() {
		return getClassResource("ajc10x.xml");
	}

	public void test001() {
		runTest("properly make choice between cast and parenthesis in parser");
	}

	public void test002() {
		runTest("field from implemented interface not found in advice");
	}

	public void test003() {
		runTest("make sure advice affects introduced methods and constructors");
	}

	public void test004() {
		runTest("new around construct");
	}

	public void test005() {
		runTest("aspect redefines a parameter");
	}

	public void test006() {
		runTest("introducing extends and implements");
	}

	public void test007() {
		runTest("(related) aspect on interface");
	}

	public void test008() {
		runTest("advice and package visibility");
	}

	public void test009() {
		runTest("advice and package visibility");
	}

	public void test010() {
		runTest("advice on implied empty constructor");
	}

	public void test011() {
		runTest("advice on * *(..) not mapping to initializers");
	}

	public void test012() {
		runTest("three type declarations in the scope of an advice");
	}

	public void test013() {
		runTest("introduction fails on class with an inner class that extends or implements something");
	}

	public void test014() {
		runTest("checks that methods are introduced on the topmost class implemented");
	}

	public void test015() {
		runTest("a couple different returns from around advice");
	}

	public void test016() {
		runTest("member finally advice paired with signature advice");
	}

	public void test017() {
		runTest("aspect of eachobject(instanceof(Interface))");
	}

	public void test018() {
		runTest("final member initialization broken with JDK before 1.1.8");
	}

	public void test019() {
		runTest("same package and var name clash in preprocessed code when aspectOf is used");
	}

	public void test020() {
		runTest("and PR#201 advice on static methods fails javac compile with this");
	}

	public void test021() {
		runTest("non-static advice on inner class defined inside of method body");
	}

	public void test022() {
		runTest("simple single-threaded eachcflow test (includes aspectOf)");
	}

	public void test023() {
		runTest("bad type resolution when var reassigned in same scope");
	}

	public void test024() {
		runTest("generating the right throws clause for call-site advice (and around)");
	}

	public void test025() {
		runTest("advice on calls to static methods using several syntax");
	}

	public void test026() {
		runTest(", PR#249, PR#250 advice on constructor sites");
	}

	public void test027() {
		runTest("test after throwing advice in several ways");
	}

	public void test028() {
		runTest("fancy name patterns for method names");
	}

	public void test029() {
		runTest("calls: calls(...)");
	}

	public void test030() {
		runTest("throws Exception clause is unnecessarily added to Driver.main method");
	}

	public void test031() {
		runTest("javac fails when this is referenced in the static main method");
	}

	public void test032() {
		runTest("and 276 cast error generated by ajc when type not in signature");
	}

	public void test033() {
		runTest("calls to methods to which we don't have source");
	}

	public void test034() {
		runTest("more aspect inheritance");
	}

	public void test035() {
		runTest("around and calls with both calling and called this params");
	}

	public void test036() {
		runTest("compiler crashes with eachobject and named pointcuts with parameters");
	}

	public void test037() {
		runTest("lookup rules for unqualified pointcut names");
	}

	public void test038() {
		runTest("eachcflow only instantiated if the aspect has some advice in it");
	}

	public void test039() {
		runTest("(DESIGN QUESTION) aspect of eachJVM advising its own initializer");
	}

	public void test040() {
		runTest("after returning advice on calls to constructors");
	}

	public void test041() {
		runTest("Does annotating 'new' with a type work as desired?");
	}

	public void test042() {
		runTest("Referring to inner classes as {super}.{inner} confused ajc.");
	}

	public void test043() {
		runTest("Advice on advice");
	}

	public void test044() {
		runTest("Introductions on other introductions");
	}

	public void test045() {
		runTest("Putting advice on array constructors.");
	}

	public void test046() {
		runTest("call points within block inner classes are doubled");
	}

	public void test047() {
		runTest("Gets and sets with other advice");
	}

	public void test048() {
		runTest("Compiler can compile correct strictfp modifiers");
	}

	public void test049() {
		runTest("basic test of callsto pointcuts");
	}

	public void test050() {
		runTest("package wildcards in packages");
	}

	public void test051() {
		runTest("around advice on calls and receptions with lots of context");
	}

	public void test052() {
		runTest("! modifier and char in pointcut (no longer an error)");
	}

	public void test053() {
		runTest("right number of aspect instances per cflow");
	}

	public void test054() {
		runTest("many this's into around advice on calls");
	}

	public void test055() {
		runTest("Ensures introduction methods can have advice placed on them");
	}

	public void test056() {
		runTest("No boolean appearing in the 'if' clause for around advice with eachJVM()");
	}

	public void test057() {
		runTest("Order of super introductions.");
	}

	public void test058() {
		runTest("Ensuring backdoor methods are produced.");
	}

	public void test059() {
		runTest("no duplicate advice methods in abstract aspects");
	}

	public void test060() {
		runTest("no duplicate advice methods in abstract aspects extended");
	}

	public void test061() {
		runTest("Putting after-constructor advice on the wrong types implementing the same interface.");
	}

	public void test062() {
		runTest("Instantiating non-static inner classes in advice.");
	}

	public void test063() {
		runTest("Referring to pointcut in of clauses");
	}

	public void test064() {
		runTest("Confused referring to instance variables and locals");
	}

	public void test065() {
		runTest("Parsing C+ expressions without parens in super introductions.");
	}

	public void test066() {
		runTest("Introducing methods on classes that implements inner-interfaces with +implements.");
	}

	public void test067() {
		runTest("Methods with the same name are generated when abstract aspects extend another abstract aspect.");
	}

	public void test068() {
		runTest("Making sure final variables stay final.");
	}

	public void test069() {
		runTest("Problem resolving meta-joinpoint names with around advice on methods called from around advice.");
	}

	public void test070() {
		runTest("Make sure that names of lifted local classes are right when referenced in call-site advice");
	}

	public void test071() {
		runTest("matching for throws clause");
	}

	public void test072() {
		runTest("basic test of declare soft");
	}

	public void test073() {
		runTest("advice on calls to constructors of anonymous inners and access to context");
	}

	public void test074() {
		runTest("inner aspects can't access outer pointcuts");
	}

	public void test075() {
		runTest("implements and extends are introduced before methods and fields");
	}

	public void test076() {
		runTest("a static/inner aspect of a inner class of an aspect is pulled to the top level as static");
	}

	public void test077() {
		runTest("Crashes with privileged aspect.");
	}

	public void test078() {
		runTest("join points exist in the execution of field initializers");
	}

	public void test079() {
		try {
			runTest("privileged aspects");
		} finally {
			System.out.println(ajc.getLastCompilationResult().getStandardError());
			System.out.println(ajc.getLastCompilationResult().getStandardOutput());
		}
	}

	public void test080() {
		runTest("advice on field gets in privileged aspects");
	}

	public void test081() {
		runTest("Two anonymous classes in the same scope");
	}

	public void test082() {
		runTest("basic tests for initializer and staticinitializer PCDs");
	}

	public void test083() {
		runTest("introduction of an initializer into a class");
	}

	public void test084() {
		runTest("some method accessibility tests, particularly package-protected and inheritance");
	}

	public void test085() {
		runTest("fairly monotonous (and non-covering) tests for expanded dot patterns");
	}

	public void test086() {
		runTest("field patterns and subtyping");
	}

	public void test087() {
		runTest("Checking formal matching as in Roeder's bug in 0.7b10");
	}

	public void test088() {
		runTest("Introducing synchronized methods on interfaces.");
	}

	public void test089() {
		runTest("The pointcut params (..,int..) is not recognizing (Object,int,Object).");
	}

	public void test090() {
		runTest("calls advice on array objects causes error in code generation");
	}

	public void test091() {
		runTest("join points in field initializers aren't showing up.");
	}

	public void test092() {
		runTest("Handlers problem");
	}

	public void test093() {
		runTest("work nicely with inner class method look-up rules and call-site advice");
	}

	public void test094() {
		runTest("strictfp modifier allowed on advice");
	}

	public void test095() {
		runTest("No argthis was being created for calls advice.");
	}

	public void test096() {
		runTest("Ensuring no advice with instanceof(..) is run on static methods.");
	}

	public void test097() {
		runTest("Null pointer on gets advice showing the case causing the error");
	}

	public void test098() {
		runTest("try to make sure that dynamic JoinPoint objects aren't generated when used inside of if (false) { ... }");
	}

	public void test099() {
		runTest("within and withincode (doesn't all work due to local class name issues)");
	}

	public void test100() {
		runTest("around advice on calls within inner classes (including protected method calls)");
	}

	public void test101() {
		runTest("around advice on calls within inner classes (including protected method calls)");
	}

	public void test102() {
		runTest("Arguments to runNext should be final when needed");
	}

	public void test103() {
		runTest("Method introductions");
	}

	public void test104() {
		runTest("Putting an introduced method on each interface");
	}

	public void test105() {
		runTest("Extending interfaces");
	}

	public void test106() {
		runTest("Introducing private methods on interfaces");
	}

	public void test107() {
		runTest("Issuing errors for assigning variables thisJoinPoint -- not assigning thisJoinPoint.");
	}

	public void test108() {
		runTest("Static references inside of introduced bodies get bound correctly.");
	}

	public void test109() {
		runTest("cflow and object creations [of eachcflow]");
	}

	public void test110() {
		runTest("Doesn't import MightHaveAspect when compiling with more than 1 file. [eachobject]");
	}

	public void test111() {
		runTest("test binding to formals in calls to constructors (binding to null) (eachobject !!! now misnamed)");
	}

	public void test112() {
		runTest("After advice isn't being woven into after throwing advice");
	}

	public void test113() {
		runTest("Throwing an EmptyStackException.");
	}

	public void test114() {
		runTest("check that MightHaveAspect interface is created correctly for an aspect in deep package");
	}

	public void test115() {
		runTest("Defines clfow$ajc0 more once. [eachcflow]");
	}

	public void test116() {
		runTest("Various calls, receptions, and callsto tests [callsto]");
	}

	public void test117() {
		runTest("Was throwing exception, now just an error. [eachobject]");
	}

	public void test118() {
		runTest("different version of aspect inheritance, particularly empty pointcuts and abstract cflows [eachcflow]");
	}

	public void test119() {
		runTest("set advice on member initing throwing exception [eachobject]");
	}

	public void test120() {
		runTest("Testing class names with same name's with difference case as package. [eachobject]");
	}

	public void test121() {
		runTest("Null pointer on gets advice with coverage [painful]");
	}

	public void test122() {
		runTest("Basic test for cflow pointcuts [eachcflow]");
	}

	public void test123() {
		runTest("Crashing when looking up the type of array members.");
	}

	public void test124() {
		runTest("PostfixExprs to various synthetic things are fixed correctly [eachobject]");
	}

	public void test125() {
		runTest("Dave Binkley's problem with eachcflowroot. [eachcflow]");
	}

	public void test126() {
		runTest("advice on an inherited method");
	}

	public void test127() {
		runTest(", PR#115 checks the ordering of catch clauses");
	}

	public void test128() {
		runTest("various declared exception permutations");
	}

	public void test129() {
		runTest("ordering of advice kinds as well as cflow and dominates");
	}

	public void test130() {
		runTest("advice on default constructor for a class only referenced via reflection");
	}

	public void test131() {
		runTest("calling and called this params in calls points");
	}

	public void test132() {
		runTest("primitive parameters coercable to Object just like return values are");
	}

	public void test133() {
		runTest("join points in static/dynamic initializers aren't showing up.");
	}

	public void test134() {
		runTest("Gets and sets on a number of variables (field access ???)");
	}

	public void test135() {
		runTest("Joinpoints are showing up on intermediate call sites");
	}

	public void test136() {
		runTest("Reception based on strictfp modifier");
	}

	public void test137() {
		runTest("Subclasses that do not redefine a method are not being handled correctly");
	}

	public void test138() {
		runTest("making sure that super calls are bound to the right methods");
	}

	public void test139() {
		runTest("inheritance, around advice and abstract pointcuts [eachobject] (still)");
	}

	public void test140() {
		runTest("Priviledged aspect methods are missing for privates. [eachobject]");
	}

	public void test141() {
		runTest("exceptions thrown and caught in advice, particularly try+proceed");
	}

	public void test142() {
		runTest("Not and And operators in pointcuts not working");
	}

	public void test143() {
		runTest("Member initializers should run before the current class constructor");
	}

	public void test144() {
		runTest("Coverage tests for Member initializers should run before the current class constructor and after super");
	}

	public void test145() {
		runTest("thisJoinPoint{Static} not visible in if() pcd of named pointcut");
	}

	public void test146() {
		runTest("pcd if() expression visibility at compile-time  (minimal operation)");
	}

	public void test147() {
		runTest("pcd if() NPE in compiler when unwinding assignment in pcd if(expr)");
	}

	public void test148() {
		runTest("pcd if() dup methods produced when pointcut after advice etc (javac)");
	}

	public void test149() {
		runTest("pcd if() variants: [anonymous, named] x [execution, call, callTyped, get, set, initializations] x [before, after, around]");
	}

	// moved to ajcTestsFailing.xml
	// public void test150(){
	// runTest("advice on advice in usejavac mode");
	// }

	public void test151() {
		runTest("initialization order with this");
	}

	public void test152() {
		runTest("!within and !this handling for callee-side call points");
	}

	public void test153() {
		runTest("private inner interfaces and bytecode visibility");
	}

	public void test154() {
		runTest("elaborated into testing of around on all join points");
	}

	public void test155() {
		runTest("type name hygiene when code comes from aspects in different packages");
	}

	public void test156() {
		runTest("cflowbelow dependencies (from Chris Dutchyn)");
	}

	public void test157() {
		runTest("Compiler incorrectly flagging *1 (non-alphabetic start to signature pattern)");
	}

	public void test158() {
		runTest("Unable to bind privately-introduced field name from introduced method in the same aspect");
	}

	public void test159() {
		runTest("anonymous inner class with aspect");
	}

	public void test160() {
		runTest("Arguments are not being passed in to calls advice");
	}

	public void test161() {
		runTest("interfaces as mixins with introduction");
	}

	public void test161b() {
		runTest("interfaces as mixins with introduction b");
	}

	public void test162() {
		runTest("functional modifiers work correctly with introduced members");
	}

	public void test163() {
		runTest("ExceptionInInitializerError accessing cflow in aspect initialization - before variants");
	}

	public void test164() {
		runTest("NoClassDefFoundError accessing cflow in aspect initialization - after variants");
	}

	public void test165() {
		runTest("InternalCompilerError in JpPlan when args alone");
	}

	public void test166() {
		runTest("compile error using pcd if() with advice on introduced methods.");
	}

	public void test167() {
		runTest("compile errors boolean using cflow and unimplemented method using around advice on methods introduced by interface");
	}

	public void test168() {
		runTest("aspect as member of interface");
	}

	public void test169() {
		runTest("missing method name to synthetic invocation");
	}

	public void test170() {
		runTest("protected subclass impl of superclass method with default access and variants");
	}

	public void test171() {
		runTest("Exception planning advice");
	}

	public void test172() {
		runTest("unreproduced bug with advice - probably UTR");
	}

	public void test173() {
		runTest("introduced inner interfaces accessible inside aspect");
	}

	public void test174() {
		runTest("validate (enclosing) join point and source locations");
	}

	public void test175() {
		runTest("advice formals are just like method formals");
	}

	public void test176() {
		runTest("advice formals produce errors just like method formals");
	}

	public void test177() {
		runTest("advice throws clauses must be compatible with joinpoints they apply to");
	}

	public void test178() {
		runTest("potential method conflicts with introductions and interfaces and PR#561");
	}

	public void test179() {
		runTest("illegal method conflicts with introductions and interfaces and PR#561");
	}

	public void test180() {
		runTest("AspectOf available for different aspect types");
	}

	public void test181() {
		runTest("access to all members of class and inner class from privileged aspect");
	}

	public void test182() {
		runTest("cflow alone with around produces compiler bcg StackOverflowError");
	}

	public void test183() {
		runTest("get/set join points run for complex assignment operators (+=, etc.) (working)");
	}

	public void test184() {
		runTest("this available in introduced field initializers");
	}

	public void test185() {
		runTest("Introduced type unavailable to cast expressions in introduced methods");
	}

	public void test186() {
		runTest("Introduced type unavailable to qualified new expressions in introduced methods");
	}

	public void test187() {
		runTest("Introduced type unavailable to cast expressions in introduced field initializers");
	}

	public void test188() {
		runTest("Aspect type unavailable to qualified new expressions in body of introduced methods");
	}

	public void test189() {
		runTest("Introduced type unavailable to qualified new expressions in introduced field initializers");
	}

	public void test190() {
		runTest("variable slots and finally/catch causing verify errors");
	}

	public void test191() {
		runTest("after advice on static method with pcd if() using result");
	}

	public void test192() {
		runTest("after advice on static method with pcd if() using result through pointcut");
	}

	public void test193() {
		runTest("AbstractMethodError for introduced methods (order 1)");
	}

	public void test194() {
		runTest("AbstractMethodError for introduced methods (order 2)");
	}

	public void test195() {
		runTest("AbstractMethodError for introduced methods (order 3)");
	}

	public void test196() {
		runTest("AbstractMethodError for introduced methods (order 4)");
	}

	public void test197() {
		runTest("AbstractMethodError for introduced methods (order 5)");
	}

	public void test198() {
		runTest("declare error and abstract pointcuts");
	}

	public void test199() {
		runTest("Exercise runtime classes (optionally in 1.1 VM)");
	}

	public void test200() {
		runTest("VerifyError after around advice falls off end of tryCatch");
	}

	public void test201() {
		runTest("Named within pointcuts failing");
	}

	public void test202() {
		runTest("aspect with private abstract pointcut");
	}

	public void test203() {
		runTest("concrete aspect unable to access abstract package-private pointcut in parent for overriding");
	}

	public void test204() {
		runTest("inner, outer, and outside-package subaspects of an aspect with abstract protected-, public-, and default-access pointcuts");
	}

	public void test205() {
		runTest("inner subaspects of an aspect with private pointcut");
	}

	public void test206() {
		runTest("outer subaspects of an aspect with private pointcut");
	}

	public void test207() {
		runTest("abstract aspect used statically should not cause instantiation of advice or pointcut");
	}

	public void test208() {
		runTest("private inner interface accessible in scope when declared on outer class");
	}

	public void test209() {
		runTest("accessing protected superclass members in and outside CCC from body of method introduction");
	}

	public void test210() {
		runTest("accessing private superclass members from body of method introduction");
	}

	public void test211() {
		runTest("simple test for around and casting");
	}

	public void test212() {
		runTest("aroundInner 1 - around advice inner Thread subclass running proceed but not writing field");
	}

	public void test213() {
		runTest("aroundInner 2 - around advice inner Runnable running proceed and writing method-final proxy");
	}

	public void test214() {
		runTest("aroundInner 3 - around advice inner class running proceed and writing field");
	}

	public void test215() {
		runTest("aroundInner 4 - around advice inner Thread subclass running proceed and writing field");
	}

	public void test216() {
		runTest("aroundInner 5 - around advice inner Runnable (subinterface) running proceed and writing field introduced on subinterface");
	}

	public void test217() {
		runTest("Named local class closing over proceed invocation");
	}

	public void test218() {
		runTest("beautiful recursive computation of factorial with around is now supported");
	}

	public void test219() {
		runTest("multi-dispatch not used for named pcd references");
	}

	public void test220() {
		runTest("multi-dispatch implemented through around + args");
	}

	public void test221() {
		runTest("unrecognized aspect should not net Cloneable and Serializable warnings");
	}

	public void test222() {
		// FIXME AV - infinite loop on JRockit in m5 advice - don't know why
		runTest("unreachable code generated by around advice on the execution of void methods");
	}

	public void test223() {
		runTest("Overriding method implementations using introduction on interfaces");
	}

	public void test224() {
		runTest("more coverage for around and concrete methods on interfaces");
	}

	public void test225() {
		runTest("invalid number and type of proceed arguments");
	}

	public void test226() {
		runTest("after returning advice order");
	}

	public void test227() {
		runTest("after returning advice param");
	}

	public void test228() {
		runTest("! and declaring types with callee-side call join points");
	}

	public void test229() {
		runTest(". Binding the wrong arguments in withincode(..).");
	}

	public void test230() {
		runTest(". Matching arguments in cflow correctly.");
	}

	public void test231() {
		runTest(". Binding variables with numbers in their name with pertarget(..)'s.");
	}

	public void test232() {
		runTest("second arg in formal on shared joinpoint with pcd if() causes verify error ??");
	}

	public void test233() {
		runTest("access to private members from privileged aspect");
	}

	public void test234() {
		runTest("inner classes of privileged aspects cannot see target class private members");
	}

	public void test235() {
		runTest("aspects should get package access outside the file");
	}

	public void test236() {
		runTest("subclass advice not run for join points selected by superclass cflow-based pointcuts");
	}

	public void test237() {
		runTest("more issues with abstract aspects and cflow pointcuts");
	}

	public void test238() {
		runTest("compile fails for aspect derived from percflow base aspect unless pointcut excludes base aspect and subaspects");
	}

	public void test239() {
		runTest("pertarget stack overflow getting name of anonymous (Interface) class");
	}

	public void test240() {
		runTest("pertarget stack overflow getting name of anonymous (Object) class");
	}

	public void test241() {
		runTest("pertarget runtime stack overflow (getting name of anonymous (Object) class?)");
	}

	public void test242() {
		runTest("subaspect method declaration on superaspect inner interface (names)");
	}

	public void test243() {
		runTest("subaspect method declaration on superaspect inner interface (access)");
	}

	public void test244() {
		runTest("subaspect method declaration on superaspect inner interface (types)");
	}

	public void test245() {
		runTest("around AST type XXX");
	}

	public void test246() {
		runTest("around all execution with double assignment in initializer (simple)");
	}

	public void test247() {
		runTest("around all execution with double assignment in initializer (coverage)");
	}

	public void test248() {
		runTest("changing this in around's proceed reported by Rich Price");
	}

	public void test249() {
		runTest("default package for aspect introductions is not the current package");
	}

	public void test250() {
		runTest("anon class written to wrong directory");
	}

	public void test251() {
		runTest("unqualified transitive pointcut references not resolved");
	}

	public void test252() {
		runTest("unqualified transitive pointcut references not resolved - 2");
	}

	public void test253() {
		runTest("direct use outside aspect of defined abstract pointcut");
	}

	public void test254() {
		runTest("direct use outside aspect of undefined abstract pointcut");
	}

	public void test255() {
		runTest("indirect use outside aspect of undefined abstract pointcut");
	}

	public void test256() {
		runTest("simple call join point tests for JoinPoint SourceLocation context");
	}

	public void test257() {
		runTest("!target with second advice on casted call");
	}

	public void test258() {
		runTest("name binding in around cflow");
	}

	public void test259() {
		runTest("name binding in around cflow - 2");
	}

	public void test260() {
		runTest("around name-binding in cflows using factorial");
	}

	public void test261() {
		runTest("replacing this or target in around advice");
	}

	public void test262() {
		runTest("after returning from initialization and after executing constructor");
	}

	public void test263() {
		runTest("after returning from initialization causes ExceptionInInitializer in aspect");
	}

	public void test264() {
		runTest("name binding in before cflow containing cflowbelow");
	}

	public void test265() {
		runTest("file order in type searching");
	}

	public void test266() {
		runTest("simple declare warning (NPE)");
	}

	public void test267() {
		runTest("ajc dies on cflow into field init anon class see knownbugs.txt");
	}

	public void test268() {
		runTest("Incrementing interface-introduced field");
	}

	public void test269() {
		runTest("The dynamic type, not the static one, should be used in if pcds");
	}

	public void test270() {
		runTest("bad interaction with after returning, around and void methods (from Rich Price)");
	}

	public void test271() {
		runTest("type pattern matching for inner classes (from Ken Horn)");
	}

	public void test272() {
		runTest("static initializer member name");
	}

	public void test273() {
		runTest("cflow pcd syntax error");
	}

	public void test274() {
		runTest("binding args with indeterminate prefix and suffix");
	}

	public void test275() {
		runTest("check arg types with indeterminate prefix and suffix");
	}

	public void test276() {
		runTest("testing and binding args with single indeterminate prefix and suffix");
	}

	public void test277() {
		runTest("binding handler args with indeterminate prefix and suffix");
	}

	public void test278() {
		runTest("Compiling java.lang.Object with ajc yields non-verifying bytecode");
	}

	public void test279() {
		runTest("method-local class defined in around return statement");
	}

	public void test280() {
		runTest("CE expected for assignment to arg in if pcd");
	}

	public void test281() {
		runTest("advising field get/sets when accessing via super");
	}

	public void test282() {
		runTest("accessing private members in outer types");
	}

	public void test283() {
		runTest("can't apply around advice to the execution of around advice");
	}

	public void test284() {
		runTest("incompatible advice throws clause are a compile-time error");
	}

}
