package common;

import java.io.*;
import java.util.Vector;

public class OutputComparator
{
    /**
      * Ignores lines that contain "Generated by javadoc on".
      *
      * @return the lines that don't match in the two files as a Vector of Strings,
      *         or null if they are the same.
      */
    public Vector compareFilesByLine(String file1, String file2) throws IOException {
        Vector diffLines = new Vector();
        BufferedReader reader1 = new BufferedReader(new FileReader(file1));
        BufferedReader reader2 = new BufferedReader(new FileReader(file2));
        String line1 = reader1.readLine();
        String line2 = reader2.readLine();
        while (line1 != null && line2 != null) {
            if (!line1.trim().equals(line2.trim()) &&
                 line1.indexOf("Generated by javadoc on") == -1 ) {
                diffLines.addElement(line1 + " != " + line2);
            }
            line1 = reader1.readLine();
            line2 = reader2.readLine();
        }
        if (diffLines.size() == 0) {
            return null;
        }
        else {
            return diffLines;
        }
    }
}
