/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.util.ScriptRunner;

public class ScriptDef
extends DefBase {
    private ScriptRunner runner = new ScriptRunner();
    private String name;
    private List attributes = new ArrayList();
    private List nestedElements = new ArrayList();
    private Set attributeSet;
    private Map nestedElementMap;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase;

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAttributeSupported(String attributeName) {
        return this.attributeSet.contains(attributeName);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void addElement(NestedElement nestedElement) {
        this.nestedElements.add(nestedElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Project project;
        if (this.name == null) {
            throw new BuildException("scriptdef requires a name attribute to name the script");
        }
        if (this.runner.getLanguage() == null) {
            throw new BuildException("<scriptdef> requires a language attribute to specify the script language");
        }
        this.attributeSet = new HashSet();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (attribute.name == null) {
                throw new BuildException("scriptdef <attribute> elements must specify an attribute name");
            }
            if (this.attributeSet.contains(attribute.name)) {
                throw new BuildException("scriptdef <" + this.name + "> declares " + "the " + attribute.name + " attribute more than once");
            }
            this.attributeSet.add(attribute.name);
        }
        this.nestedElementMap = new HashMap();
        Iterator i2 = this.nestedElements.iterator();
        while (i2.hasNext()) {
            NestedElement nestedElement = (NestedElement)i2.next();
            if (nestedElement.name == null) {
                throw new BuildException("scriptdef <element> elements must specify an element name");
            }
            if (this.nestedElementMap.containsKey(nestedElement.name)) {
                throw new BuildException("scriptdef <" + this.name + "> declares " + "the " + nestedElement.name + " nested element more " + "than once");
            }
            if (nestedElement.className == null && nestedElement.type == null) {
                throw new BuildException("scriptdef <element> elements must specify either a classname or type attribute");
            }
            if (nestedElement.className != null && nestedElement.type != null) {
                throw new BuildException("scriptdef <element> elements must specify only one of the classname and type attributes");
            }
            this.nestedElementMap.put(nestedElement.name, nestedElement);
        }
        HashMap<String, ScriptDef> scriptRepository = null;
        Project project2 = project = this.getProject();
        synchronized (project2) {
            scriptRepository = (HashMap<String, ScriptDef>)project.getReference("org.apache.ant.scriptrepo");
            if (scriptRepository == null) {
                scriptRepository = new HashMap<String, ScriptDef>();
                project.addReference("org.apache.ant.scriptrepo", scriptRepository);
            }
        }
        this.name = ProjectHelper.genComponentName((String)this.getURI(), (String)this.name);
        scriptRepository.put(this.name, this);
        AntTypeDefinition def = new AntTypeDefinition();
        def.setName(this.name);
        def.setClass(class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase == null ? (class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase = ScriptDef.class$("org.apache.tools.ant.taskdefs.optional.script.ScriptDefBase")) : class$org$apache$tools$ant$taskdefs$optional$script$ScriptDefBase);
        ComponentHelper.getComponentHelper((Project)this.getProject()).addDataTypeDefinition(def);
    }

    public Object createNestedElement(String elementName) {
        NestedElement definition = (NestedElement)this.nestedElementMap.get(elementName);
        if (definition == null) {
            throw new BuildException("<" + this.name + "> does not support " + "the <" + elementName + "> nested element");
        }
        Object instance = null;
        String classname = definition.className;
        if (classname == null) {
            instance = this.getProject().createTask(definition.type);
            if (instance == null) {
                instance = this.getProject().createDataType(definition.type);
            }
        } else {
            ClassLoader loader = this.createLoader();
            Class<?> instanceClass = null;
            try {
                instanceClass = Class.forName(classname, true, loader);
            }
            catch (Throwable e) {
                try {
                    instanceClass = Class.forName(classname);
                }
                catch (Throwable e2) {
                    throw new BuildException("scriptdef: Unable to load class " + classname + " for nested element <" + elementName + ">", e2);
                }
            }
            try {
                instance = instanceClass.newInstance();
            }
            catch (Throwable e) {
                throw new BuildException("scriptdef: Unable to create element of class " + classname + " for nested " + "element <" + elementName + ">", e);
            }
            this.getProject().setProjectReference(instance);
        }
        if (instance == null) {
            throw new BuildException("<" + this.name + "> is unable to create " + "the <" + elementName + "> nested element");
        }
        return instance;
    }

    public void executeScript(Map attributes, Map elements) {
        this.runner.addBean("attributes", attributes);
        this.runner.addBean("elements", elements);
        this.runner.addBean("project", this.getProject());
        this.runner.executeScript("scriptdef_" + this.name);
    }

    public void setLanguage(String language) {
        this.runner.setLanguage(language);
    }

    public void setSrc(File file) {
        this.runner.setSrc(file);
    }

    public void addText(String text) {
        this.runner.addText(text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NestedElement {
        private String name;
        private String type;
        private String className;

        public void setName(String name) {
            this.name = name.toLowerCase(Locale.US);
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setClassName(String className) {
            this.className = className;
        }
    }

    public static class Attribute {
        private String name;

        public void setName(String name) {
            this.name = name.toLowerCase(Locale.US);
        }
    }
}

