/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.util.LangUtil;

public class Tester {
    private static IMessageHandler messageHandler;
    private static File BASEDIR;
    private static Set notes;
    private static List actualEvents;
    private static List expectedEvents;

    public static void setBASEDIR(File baseDir) {
        if (null == baseDir) {
            throw new IllegalArgumentException("null baseDir");
        }
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + baseDir);
        }
        BASEDIR = baseDir;
    }

    public static File getBASEDIR() {
        return BASEDIR;
    }

    public static void setMessageHandler(IMessageHandler handler) {
        if (null == handler) {
            throw new IllegalArgumentException("null handler");
        }
        if (messageHandler != handler) {
            messageHandler = handler;
        }
    }

    public static void clear() {
        Tester.clearNotes();
        Tester.clearEvents();
    }

    public static void clearNotes() {
        notes = new HashSet();
    }

    public static void clearEvents() {
        actualEvents = new ArrayList();
        expectedEvents = new ArrayList();
    }

    public static void event(String s) {
        actualEvents.add(s);
    }

    public static void note(Object note) {
        notes.add(note);
    }

    public static void check(Object note) {
        Tester.check(note, "expected note \"" + note.toString() + "\"");
    }

    public static void check(Object note, String message) {
        Tester.check(notes.contains(note), message);
    }

    public static void throwable(Throwable t) {
        Tester.throwable(t, null);
    }

    public static void throwable(Throwable thrown, String msg) {
        Tester.handle(msg, thrown, true);
    }

    public static void checkFailed(String message) {
        Tester.handle(message, null, true);
    }

    public static void checkAndClear(String expectedNotes, String msg) {
        Tester.checkEqual((Collection)notes, expectedNotes, msg);
        Tester.clearNotes();
    }

    public static void check(boolean test, String message) {
        if (!test) {
            Tester.checkFailed(message);
        }
    }

    public static void checkEqual(Object[] value, Object[] expectedValue, String message) {
        if (value == null) {
            if (expectedValue == null) {
                return;
            }
            Tester.checkFailed(message + " null array found");
            return;
        }
        int n = value.length;
        if (n != expectedValue.length) {
            Tester.checkFailed(message + " expected array of length " + expectedValue.length + " got " + n);
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (value[i].equals(expectedValue[i])) continue;
            Tester.checkFailed(message + ": " + value[i] + " != " + expectedValue[i] + " at index " + i);
        }
    }

    public static void checkNotEqual(boolean s, boolean t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(boolean s, boolean t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(byte s, byte t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(byte s, byte t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(char s, char t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(char s, char t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(short s, short t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(short s, short t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(int s, int t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(int s, int t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(long s, long t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(long s, long t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(float s, float t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(float s, float t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(double s, double t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(double s, double t, String msg) {
        if (s == t) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkNotEqual(Object s, Object t) {
        Tester.checkNotEqual(s, t, s + " shouldn't equal " + t);
    }

    public static void checkNotEqual(Object s, Object t, String msg) {
        if (s != null && s.equals(t) || t != null && t.equals(s) || s == null && t == null) {
            Tester.checkFailed(msg);
        }
    }

    public static void checkEqual(int value, int expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkNonNull(Object o, String name) {
        if (o == null) {
            Tester.checkFailed(name + " shouldn't be null");
        }
    }

    public static void checkEqual(int value, int expectedValue, String message) {
        if (value == expectedValue) {
            return;
        }
        message = value < expectedValue ? message + ": " + value + " < " + expectedValue : message + ": " + value + " > " + expectedValue;
        Tester.checkFailed(message);
    }

    public static void checkEqual(float value, float expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(float value, float expectedValue, String msg) {
        if (Float.isNaN(value) && Float.isNaN(expectedValue)) {
            return;
        }
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(long value, long expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(long value, long expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(double value, double expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(double value, double expectedValue, String msg) {
        if (Double.isNaN(value) && Double.isNaN(expectedValue)) {
            return;
        }
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(short value, short expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(short value, short expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(byte value, byte expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(byte value, byte expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(char value, char expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(char value, char expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = value < expectedValue ? msg + ": " + value + " < " + expectedValue : msg + ": " + value + " > " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(boolean value, boolean expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(boolean value, boolean expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = msg + ": " + value + " != " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEqual(Collection set, String expectedSet, String msg) {
        Tester.checkEqual(set, LangUtil.split((String)expectedSet), msg);
    }

    public static void checkEqualIgnoreDups(Collection set, String[] expected, String msg, boolean ignoreDups) {
        String[] diffs = Tester.diffIgnoreDups(set, expected, msg, ignoreDups);
        if (0 < diffs.length) {
            Tester.check(false, "" + Arrays.asList(diffs));
        }
    }

    private static String[] diffIgnoreDups(Collection set, String[] expected, String msg, boolean ignoreDups) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList actual = new ArrayList(set);
        BitSet hits = new BitSet();
        for (int i = 0; i < expected.length; ++i) {
            if (!actual.remove(expected[i])) {
                result.add(" expected " + msg + " \"" + expected[i] + "\" not found");
                continue;
            }
            hits.set(i);
            if (!ignoreDups) continue;
            while (actual.remove(expected[i])) {
            }
        }
        Iterator iter = ((AbstractList)actual).iterator();
        while (iter.hasNext()) {
            String act = (String)iter.next();
            result.add(" unexpected " + msg + " \"" + act + "\" found");
        }
        return result.toArray(new String[0]);
    }

    public static void checkEqual(Collection set, String[] expected, String msg) {
        Tester.checkEqualIgnoreDups(set, expected, msg, false);
    }

    public static void checkEqual(Object value, Object expectedValue) {
        Tester.checkEqual(value, expectedValue, "compare");
    }

    public static void checkEqual(Object value, Object expectedValue, String msg) {
        if (value == null && expectedValue == null) {
            return;
        }
        if (value != null && value.equals(expectedValue)) {
            return;
        }
        msg = msg + ": " + value + " !equals " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void checkEq(Object value, Object expectedValue, String msg) {
        if (value == expectedValue) {
            return;
        }
        msg = msg + ": " + value + " != " + expectedValue;
        Tester.checkFailed(msg);
    }

    public static void expectEvent(String s) {
        if (null != s) {
            expectedEvents.add(s);
        }
    }

    public static void expectEvent(Object s) {
        if (null != s) {
            Tester.expectEvent(s.toString());
        }
    }

    public static void expectEventsInString(String s) {
        if (null != s) {
            StringTokenizer tok = new StringTokenizer(s, ":;, ");
            while (tok.hasMoreTokens()) {
                Tester.expectEvent(tok.nextToken());
            }
        }
    }

    public static void expectEventsInString(String[] ra) {
        Tester.expectEvents((Object[])ra);
    }

    public static void expectEvents(Object[] events) {
        if (null != events) {
            for (int i = 0; i < events.length; ++i) {
                if (null == events[i]) continue;
                Tester.expectEvent(events[i].toString());
            }
        }
    }

    public static void expectEvents(String[] events) {
        if (null != events) {
            for (int i = 0; i < events.length; ++i) {
                if (null == events[i]) continue;
                Tester.expectEvent(events[i].toString());
            }
        }
    }

    public static void checkAllEvents() {
        Tester.checkAndClearEvents(expectedEvents.toArray(new String[0]));
    }

    public static void checkAllEventsIgnoreDups() {
        boolean ignoreDups = true;
        String[] exp = expectedEvents.toArray(new String[0]);
        Tester.checkEqualIgnoreDups(actualEvents, exp, "event", true);
        Tester.clearEvents();
    }

    public static void checkEventsFromFile(String eventsFile) {
        try {
            String line;
            File file = new File(Tester.getBASEDIR(), eventsFile);
            BufferedReader in = new BufferedReader(new FileReader(file));
            ArrayList<String> expEvents = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() < 1 || line.startsWith("//")) continue;
                expEvents.add(line);
            }
            Tester.checkEqualLists(actualEvents, expEvents, " from " + eventsFile);
        }
        catch (IOException ioe) {
            Tester.throwable(ioe);
        }
    }

    public static void checkEqualLists(List actual, List expected, String message) {
        Iterator a = actual.iterator();
        Iterator e = expected.iterator();
        int ai = 0;
        int ei = 0;
        while (a.hasNext()) {
            String e0;
            if (!e.hasNext()) {
                Tester.checkFailed("unexpected [" + ai + "] \"" + a.next() + "\" " + message);
                return;
            }
            String a0 = ((String)a.next()).trim();
            if (!a0.equals(e0 = ((String)e.next()).trim())) {
                Tester.checkFailed("expected [" + ei + "] \"" + e0 + "\"\n  but found [" + ai + "] \"" + a0 + "\"\n  " + message);
                return;
            }
            ++ai;
            ++ei;
        }
        while (e.hasNext()) {
            Tester.checkFailed("expected [" + ei + "] \"" + e.next() + "\" " + message);
            ++ei;
        }
    }

    public static void checkEvents(String expEvents) {
        Tester.checkEqual((Collection)actualEvents, expEvents, "event");
    }

    public static void checkEvents(String[] expEvents) {
        Tester.checkEqual((Collection)actualEvents, expEvents, "event");
    }

    public static void checkAndClearEvents(String expEvents) {
        Tester.checkEvents(expEvents);
        Tester.clearEvents();
    }

    public static void checkAndClearEvents(String[] expEvents) {
        Tester.checkEvents(expEvents);
        Tester.clearEvents();
    }

    public static void printEvents() {
        Iterator i = actualEvents.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public void unexpectedExceptionFailure(Throwable thrown) {
        Tester.handle("unexpectedExceptionFailure", thrown, true);
    }

    private static void handle(String message, Throwable thrown, boolean fail) {
        boolean failed = fail || null != thrown;
        IMessage.Kind kind = failed ? IMessage.FAIL : IMessage.INFO;
        Message m = new Message(message, kind, thrown, null);
        messageHandler.handleMessage((IMessage)m);
    }

    static {
        actualEvents = new ArrayList();
        expectedEvents = new ArrayList();
        Tester.setBASEDIR(new File("."));
        Tester.setMessageHandler(IMessageHandler.SYSTEM_ERR);
        Tester.clear();
    }
}

