/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.net.URL;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.render.awt.AWTFontMetrics;

public class FontMetricsMapper
implements FontMetric {
    private static final int FIRST_CHAR = 32;
    private static final int LAST_CHAR = 255;
    private static AWTFontMetrics metric = null;
    private final String family;
    private final int style;

    public FontMetricsMapper(String family, int style, Graphics2D graphics) {
        this.family = family;
        this.style = style;
        if (metric == null) {
            metric = new AWTFontMetrics(graphics);
        }
    }

    public int getAscender(int size) {
        return metric.getAscender(this.family, this.style, size);
    }

    public int getCapHeight(int size) {
        return metric.getCapHeight(this.family, this.style, size);
    }

    public int getDescender(int size) {
        return metric.getDescender(this.family, this.style, size);
    }

    public int getFirstChar() {
        return 32;
    }

    public Font getFont(int size) {
        return metric.getFont(this.family, this.style, size);
    }

    public int getLastChar() {
        return 255;
    }

    public int[] getWidths(int size) {
        return metric.getWidths(this.family, this.style, size);
    }

    public int getXHeight(int size) {
        return metric.getXHeight(this.family, this.style, size);
    }

    public void setEmbedFont(URL fontURL) {
        metric.setEmbedFont(this.family, this.style, fontURL);
    }

    public int width(int i, int size) {
        return metric.width(i, this.family, this.style, size);
    }
}

