/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.messaging.MessageHandler;

public class FixedLength
extends Length {
    public FixedLength(double numRelUnits, int iCurFontSize) {
        this.setComputedValue((int)(numRelUnits * (double)iCurFontSize));
    }

    public FixedLength(double numUnits, String units) {
        this.convert(numUnits, units);
    }

    public FixedLength(int baseUnits) {
        this.setComputedValue(baseUnits);
    }

    public Numeric asNumeric() {
        return new Numeric(this);
    }

    protected void convert(double dvalue, String unit) {
        boolean assumed_resolution = true;
        if (unit.equals("in")) {
            dvalue *= 72.0;
        } else if (unit.equals("cm")) {
            dvalue *= 28.3464567;
        } else if (unit.equals("mm")) {
            dvalue *= 2.83464567;
        } else if (!unit.equals("pt")) {
            if (unit.equals("pc")) {
                dvalue *= 12.0;
            } else if (unit.equals("px")) {
                dvalue *= (double)assumed_resolution;
            } else {
                dvalue = 0.0;
                MessageHandler.errorln("unknown length unit '" + unit + "'");
            }
        }
        this.setComputedValue((int)(dvalue * 1000.0));
    }
}

