/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.AbstractMetamataTask;
import org.apache.tools.ant.taskdefs.optional.metamata.MAuditStreamHandler;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class MAudit
extends AbstractMetamataTask {
    static final String AUDIT_PATTERN = "(?:file:)?(.+):(\\d+)\\s*:\\s+(.*)";
    private File outFile = null;
    private Path searchPath = null;
    private Path rulesPath = null;
    private boolean fix = false;
    private boolean list = false;
    private boolean unused = false;
    private boolean quiet = false;
    private boolean exit = false;
    private boolean offsets = false;
    private boolean verbose = false;
    private boolean fullsemanticize = false;

    public MAudit() {
        super("com.metamata.gui.rc.MAudit");
    }

    public void setTofile(File outFile) {
        this.outFile = outFile;
    }

    public void setFix(boolean flag) {
        this.fix = flag;
    }

    public void setList(boolean flag) {
        this.list = flag;
    }

    public void setUnused(boolean flag) {
        this.unused = flag;
    }

    public void setQuiet(boolean flag) {
        this.quiet = flag;
    }

    public void setExit(boolean flag) {
        this.exit = flag;
    }

    public void setOffsets(boolean flag) {
        this.offsets = flag;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setFullsemanticize(boolean flag) {
        this.fullsemanticize = flag;
    }

    public Path createRulespath() {
        if (this.rulesPath == null) {
            this.rulesPath = new Path(this.getProject());
        }
        return this.rulesPath;
    }

    public Path createSearchpath() {
        if (this.searchPath == null) {
            this.searchPath = new Path(this.getProject());
        }
        return this.searchPath;
    }

    protected Vector getOptions() {
        Vector<String> options = new Vector<String>(512);
        int i = 0;
        while (i < this.fileSets.size()) {
            FileSet fs = (FileSet)this.fileSets.elementAt(i);
            Path path = this.createSourcepath();
            File dir = fs.getDir(this.getProject());
            path.setLocation(dir);
            ++i;
        }
        if (this.sourcePath != null) {
            this.sourcePath.append(this.classPath);
            this.classPath = this.sourcePath;
            this.sourcePath = null;
        }
        if (this.classPath != null) {
            options.addElement("-classpath");
            options.addElement(this.classPath.toString());
        }
        if (this.quiet) {
            options.addElement("-quiet");
        }
        if (this.fullsemanticize) {
            options.addElement("-full-semanticize");
        }
        if (this.verbose) {
            options.addElement("-verbose");
        }
        if (this.offsets) {
            options.addElement("-offsets");
        }
        if (this.exit) {
            options.addElement("-exit");
        }
        if (this.fix) {
            options.addElement("-fix");
        }
        options.addElement("-fullpath");
        if (this.list) {
            options.addElement("-list");
        }
        if (this.sourcePath != null) {
            options.addElement("-sourcepath");
            options.addElement(this.sourcePath.toString());
        }
        AbstractMetamataTask.addAllVector(options, this.includedFiles.keys());
        if (this.unused) {
            options.addElement("-unused");
            options.addElement(this.searchPath.toString());
        }
        return options;
    }

    protected void checkOptions() throws BuildException {
        super.checkOptions();
        if (this.unused && this.searchPath == null) {
            throw new BuildException("'searchpath' element must be set when looking for 'unused' declarations.");
        }
        if (!this.unused && this.searchPath != null) {
            this.log("'searchpath' element ignored. 'unused' attribute is disabled.", 1);
        }
        if (this.rulesPath != null) {
            this.cmdl.createClasspath(this.getProject()).addExisting(this.rulesPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ExecuteStreamHandler createStreamHandler() throws BuildException {
        if (this.outFile == null) {
            return new LogStreamHandler((Task)this, 2, 0);
        }
        MAuditStreamHandler handler = null;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.outFile);
                handler = new MAuditStreamHandler(this, out);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            Object var5_3 = null;
            if (out != null) return handler;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (out != null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((OutputStream)out).close();
        return handler;
    }

    protected void cleanUp() throws BuildException {
        super.cleanUp();
    }
}

