/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class WildcardBinding
extends ReferenceBinding {
    ReferenceBinding genericType;
    int rank;
    public TypeBinding bound;
    char[] genericSignature;
    public int kind;
    ReferenceBinding superclass;
    ReferenceBinding[] superInterfaces;
    TypeVariableBinding typeVariable;
    LookupEnvironment environment;

    public WildcardBinding(ReferenceBinding genericType, int rank, TypeBinding bound, int kind, LookupEnvironment environment) {
        this.genericType = genericType;
        this.rank = rank;
        this.kind = kind;
        this.modifiers = 0x40000001;
        this.environment = environment;
        this.initialize(genericType, bound);
        if (genericType instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)genericType).addWrapper(this);
        }
        if (bound instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)bound).addWrapper(this);
        }
    }

    public int kind() {
        return 260;
    }

    public boolean boundCheck(TypeBinding argumentType) {
        switch (this.kind) {
            case 0: {
                return true;
            }
            case 1: {
                return argumentType.isCompatibleWith(this.bound);
            }
        }
        return this.bound.isCompatibleWith(argumentType) || argumentType.isCompatibleWith(this.bound);
    }

    public boolean canBeInstantiated() {
        return false;
    }

    public void collectSubstitutes(TypeBinding otherType, Map substitutes) {
        if (this.bound == null) {
            return;
        }
        if (otherType.isWildcard()) {
            WildcardBinding otherWildcard = (WildcardBinding)otherType;
            if (otherWildcard.bound != null) {
                this.bound.collectSubstitutes(otherWildcard.bound, substitutes);
            }
        } else {
            this.bound.collectSubstitutes(otherType, substitutes);
        }
    }

    public String debugName() {
        return this.toString();
    }

    public TypeBinding erasure() {
        if (this.kind == 1) {
            return this.bound.erasure();
        }
        return this.typeVariable().erasure();
    }

    public char[] genericTypeSignature() {
        if (this.genericSignature == null) {
            switch (this.kind) {
                case 0: {
                    this.genericSignature = TypeConstants.WILDCARD_STAR;
                    break;
                }
                case 1: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_PLUS, this.bound.genericTypeSignature());
                    break;
                }
                default: {
                    this.genericSignature = CharOperation.concat(TypeConstants.WILDCARD_MINUS, this.bound.genericTypeSignature());
                }
            }
        }
        return this.genericSignature;
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    void initialize(ReferenceBinding someGenericType, TypeBinding someBound) {
        this.genericType = someGenericType;
        this.bound = someBound;
        if (someGenericType != null) {
            this.fPackage = someGenericType.getPackage();
        }
        if (someBound != null && someBound.isTypeVariable()) {
            this.tagBits |= 0x20000000L;
        }
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        if (this.kind == 2) {
            if (this.bound instanceof ReferenceBinding) {
                return ((ReferenceBinding)this.bound).isSuperclassOf(otherType);
            }
            return otherType.id == 1;
        }
        return false;
    }

    public boolean isUnboundWildcard() {
        return this.kind == 0;
    }

    public boolean isWildcard() {
        return true;
    }

    public char[] readableName() {
        switch (this.kind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.readableName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.readableName());
    }

    ReferenceBinding resolve() {
        BinaryTypeBinding.resolveType(this.genericType, this.environment, null, 0);
        switch (this.kind) {
            case 1: 
            case 2: {
                BinaryTypeBinding.resolveType(this.bound, this.environment, null, 0);
            }
        }
        return this;
    }

    public char[] shortReadableName() {
        switch (this.kind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.shortReadableName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.shortReadableName());
    }

    public char[] signature() {
        if (this.signature == null) {
            switch (this.kind) {
                case 1: {
                    return this.bound.signature();
                }
            }
            return this.typeVariable().signature();
        }
        return this.signature;
    }

    public char[] sourceName() {
        switch (this.kind) {
            case 0: {
                return TypeConstants.WILDCARD_NAME;
            }
            case 1: {
                return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.sourceName());
            }
        }
        return CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.sourceName());
    }

    public ReferenceBinding superclass() {
        if (this.superclass == null) {
            TypeBinding superType = this.typeVariable().firstBound;
            if (this.kind == 1 && this.bound.isClass()) {
                superType = this.bound;
            }
            this.superclass = superType != null && superType.isClass() ? superType : this.environment.getType(TypeConstants.JAVA_LANG_OBJECT);
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if (this.superInterfaces == null) {
            this.superInterfaces = this.typeVariable() != null ? this.typeVariable.superInterfaces() : TypeConstants.NoSuperInterfaces;
            if (this.kind == 1 && this.bound.isInterface()) {
                int length = this.superInterfaces.length;
                this.superInterfaces = new ReferenceBinding[length + 1];
                System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 1, length);
                this.superInterfaces[0] = (ReferenceBinding)this.bound;
            }
        }
        return this.superInterfaces;
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment env) {
        boolean affected = false;
        if (this.genericType == unresolvedType) {
            this.genericType = resolvedType;
            affected = true;
        } else if (this.bound == unresolvedType) {
            this.bound = resolvedType.isGenericType() ? env.createRawType(resolvedType, resolvedType.enclosingType()) : resolvedType;
            affected = true;
        }
        if (affected) {
            this.initialize(this.genericType, this.bound);
        }
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return new String(TypeConstants.WILDCARD_NAME);
            }
            case 1: {
                return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_EXTENDS, this.bound.debugName().toCharArray()));
            }
        }
        return new String(CharOperation.concat(TypeConstants.WILDCARD_NAME, TypeConstants.WILDCARD_SUPER, this.bound.debugName().toCharArray()));
    }

    public TypeVariableBinding typeVariable() {
        TypeVariableBinding[] typeVariables;
        if (this.typeVariable == null && this.rank < (typeVariables = this.genericType.typeVariables()).length) {
            this.typeVariable = typeVariables[this.rank];
        }
        return this.typeVariable;
    }
}

