/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.codeassist;

import java.util.Locale;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.aspectj.org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionOnImportReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionOnPackageReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionOnQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionOnSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.select.SelectionParser;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.SelectionRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.SourceType;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.ASTNodeFinder;

public final class SelectionEngine
extends Engine
implements ISearchRequestor {
    public static boolean DEBUG = false;
    SelectionParser parser;
    ISelectionRequestor requestor;
    boolean acceptedAnswer;
    private int actualSelectionStart;
    private int actualSelectionEnd;
    private char[] selectedIdentifier;
    private char[][][] acceptedClasses;
    private char[][][] acceptedInterfaces;
    private char[][][] acceptedEnums;
    private char[][][] acceptedAnnotations;
    int acceptedClassesCount;
    int acceptedInterfacesCount;
    int acceptedEnumsCount;
    int acceptedAnnotationsCount;
    boolean noProposal = true;
    IProblem problem = null;

    public SelectionEngine(SearchableEnvironment nameEnvironment, ISelectionRequestor requestor, Map settings) {
        super(settings);
        this.requestor = requestor;
        this.nameEnvironment = nameEnvironment;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory(Locale.getDefault())){

            public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber) {
                IProblem pb = super.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber);
                if (SelectionEngine.this.problem == null && pb.isError() && (pb.getID() & 0x40000000) == 0) {
                    SelectionEngine.this.problem = pb;
                }
                return pb;
            }
        };
        this.lookupEnvironment = new LookupEnvironment(this, this.compilerOptions, problemReporter, nameEnvironment);
        this.parser = new SelectionParser(problemReporter);
    }

    public void acceptAnnotation(char[] packageName, char[] typeName, int modifiers, AccessRestriction accessRestriction) {
        if (CharOperation.equals(typeName, this.selectedIdentifier)) {
            if (this.mustQualifyType(packageName, typeName)) {
                int length;
                char[][] acceptedAnnotation = new char[][]{packageName, typeName};
                if (this.acceptedAnnotations == null) {
                    this.acceptedAnnotations = new char[10][][];
                    this.acceptedAnnotationsCount = 0;
                }
                if ((length = this.acceptedAnnotations.length) == this.acceptedAnnotationsCount) {
                    this.acceptedAnnotations = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedAnnotations, 0, this.acceptedAnnotations, 0, length);
                }
                this.acceptedAnnotations[this.acceptedAnnotationsCount++] = acceptedAnnotation;
            } else {
                this.noProposal = false;
                this.requestor.acceptAnnotation(packageName, typeName, false, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptClass(char[] packageName, char[] className, int modifiers, AccessRestriction accessRestriction) {
        if (CharOperation.equals(className, this.selectedIdentifier)) {
            if (this.mustQualifyType(packageName, className)) {
                int length;
                char[][] acceptedClass = new char[][]{packageName, className};
                if (this.acceptedClasses == null) {
                    this.acceptedClasses = new char[10][][];
                    this.acceptedClassesCount = 0;
                }
                if ((length = this.acceptedClasses.length) == this.acceptedClassesCount) {
                    this.acceptedClasses = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedClasses, 0, this.acceptedClasses, 0, length);
                }
                this.acceptedClasses[this.acceptedClassesCount++] = acceptedClass;
            } else {
                this.noProposal = false;
                this.requestor.acceptClass(packageName, className, false, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptEnum(char[] packageName, char[] typeName, int modifiers, AccessRestriction accessRestriction) {
        if (CharOperation.equals(typeName, this.selectedIdentifier)) {
            if (this.mustQualifyType(packageName, typeName)) {
                int length;
                char[][] acceptedEnum = new char[][]{packageName, typeName};
                if (this.acceptedEnums == null) {
                    this.acceptedEnums = new char[10][][];
                    this.acceptedEnumsCount = 0;
                }
                if ((length = this.acceptedEnums.length) == this.acceptedEnumsCount) {
                    this.acceptedEnums = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedEnums, 0, this.acceptedEnums, 0, length);
                }
                this.acceptedEnums[this.acceptedEnumsCount++] = acceptedEnum;
            } else {
                this.noProposal = false;
                this.requestor.acceptEnum(packageName, typeName, false, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, int modifiers, AccessRestriction accessRestriction) {
        if (CharOperation.equals(interfaceName, this.selectedIdentifier)) {
            if (this.mustQualifyType(packageName, interfaceName)) {
                int length;
                char[][] acceptedInterface = new char[][]{packageName, interfaceName};
                if (this.acceptedInterfaces == null) {
                    this.acceptedInterfaces = new char[10][][];
                    this.acceptedInterfacesCount = 0;
                }
                if ((length = this.acceptedInterfaces.length) == this.acceptedInterfacesCount) {
                    this.acceptedInterfaces = new char[(length + 1) * 2][][];
                    System.arraycopy(this.acceptedInterfaces, 0, this.acceptedInterfaces, 0, length);
                }
                this.acceptedInterfaces[this.acceptedInterfacesCount++] = acceptedInterface;
            } else {
                this.noProposal = false;
                this.requestor.acceptInterface(packageName, interfaceName, false, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.acceptedAnswer = true;
            }
        }
    }

    public void acceptPackage(char[] packageName) {
    }

    private void acceptQualifiedTypes() {
        int i;
        if (this.acceptedClasses != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedClassesCount) {
                this.noProposal = false;
                this.requestor.acceptClass(this.acceptedClasses[i][0], this.acceptedClasses[i][1], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedClasses = null;
            this.acceptedClassesCount = 0;
        }
        if (this.acceptedInterfaces != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedInterfacesCount) {
                this.noProposal = false;
                this.requestor.acceptInterface(this.acceptedInterfaces[i][0], this.acceptedInterfaces[i][1], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedInterfaces = null;
            this.acceptedInterfacesCount = 0;
        }
        if (this.acceptedAnnotations != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedAnnotationsCount) {
                this.noProposal = false;
                this.requestor.acceptAnnotation(this.acceptedAnnotations[i][0], this.acceptedAnnotations[i][1], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedAnnotations = null;
            this.acceptedAnnotationsCount = 0;
        }
        if (this.acceptedEnums != null) {
            this.acceptedAnswer = true;
            i = 0;
            while (i < this.acceptedEnumsCount) {
                this.noProposal = false;
                this.requestor.acceptEnum(this.acceptedEnums[i][0], this.acceptedEnums[i][1], false, null, this.actualSelectionStart, this.actualSelectionEnd);
                ++i;
            }
            this.acceptedEnums = null;
            this.acceptedEnumsCount = 0;
        }
    }

    private boolean checkSelection(char[] source, int selectionStart, int selectionEnd) {
        Scanner scanner = new Scanner();
        scanner.setSource(source);
        int lastIdentifierStart = -1;
        int lastIdentifierEnd = -1;
        char[] lastIdentifier = null;
        if (selectionStart > selectionEnd) {
            int token;
            int currentPosition = selectionStart - 1;
            int nextCharacterPosition = selectionStart;
            int currentCharacter = 32;
            try {
                while (currentPosition > 0) {
                    if (source[currentPosition] == '\\' && source[currentPosition + 1] == 'u') {
                        int pos = currentPosition + 2;
                        int c1 = 0;
                        int c2 = 0;
                        int c3 = 0;
                        int c4 = 0;
                        while (source[pos] == 'u') {
                            ++pos;
                        }
                        if ((c1 = Character.getNumericValue(source[pos++])) > 15 || c1 < 0 || (c2 = Character.getNumericValue(source[pos++])) > 15 || c2 < 0 || (c3 = Character.getNumericValue(source[pos++])) > 15 || c3 < 0 || (c4 = Character.getNumericValue(source[pos++])) > 15 || c4 < 0) {
                            return false;
                        }
                        currentCharacter = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
                        nextCharacterPosition = pos;
                    } else {
                        currentCharacter = source[currentPosition];
                        nextCharacterPosition = currentPosition + 1;
                    }
                    if (currentCharacter != 13 && currentCharacter != 10) {
                        --currentPosition;
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            scanner.resetTo(nextCharacterPosition, selectionEnd + 1 == source.length ? selectionEnd : selectionEnd + 1);
            do {
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException e) {
                    return false;
                }
                if (token != 49 && token != 48 && token != 22 || scanner.startPosition > selectionStart || selectionStart > scanner.currentPosition) continue;
                lastIdentifierStart = scanner.startPosition;
                lastIdentifierEnd = scanner.currentPosition - 1;
                lastIdentifier = scanner.getCurrentTokenSource();
            } while (token != 75);
        } else {
            scanner.resetTo(selectionStart, selectionEnd);
            boolean expectingIdentifier = true;
            try {
                int token;
                block15: do {
                    token = scanner.getNextToken();
                    switch (token) {
                        case 22: 
                        case 48: 
                        case 49: {
                            if (!expectingIdentifier) {
                                return false;
                            }
                            lastIdentifier = scanner.getCurrentTokenSource();
                            lastIdentifierStart = scanner.startPosition;
                            lastIdentifierEnd = scanner.currentPosition - 1;
                            if (lastIdentifierEnd > selectionEnd) {
                                lastIdentifierEnd = selectionEnd;
                                lastIdentifier = CharOperation.subarray(lastIdentifier, 0, lastIdentifierEnd - lastIdentifierStart + 1);
                            }
                            expectingIdentifier = false;
                            break;
                        }
                        case 2: {
                            if (expectingIdentifier) {
                                return false;
                            }
                            expectingIdentifier = true;
                            break;
                        }
                        case 75: {
                            if (!expectingIdentifier) continue block15;
                            return false;
                        }
                        case 7: {
                            if (this.checkTypeArgument(scanner)) continue block15;
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                } while (token != 75);
            }
            catch (InvalidInputException e) {
                return false;
            }
        }
        if (lastIdentifierStart > 0) {
            this.actualSelectionStart = lastIdentifierStart;
            this.actualSelectionEnd = lastIdentifierEnd;
            this.selectedIdentifier = lastIdentifier;
            return true;
        }
        return false;
    }

    private boolean checkTypeArgument(Scanner scanner) throws InvalidInputException {
        char[] typeRef;
        int length;
        int token;
        int depth = 1;
        StringBuffer buffer = new StringBuffer();
        do {
            token = scanner.getNextToken();
            switch (token) {
                case 7: {
                    ++depth;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 14: {
                    --depth;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 8: {
                    depth -= 2;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 11: {
                    depth -= 3;
                    buffer.append(scanner.getCurrentTokenSource());
                    break;
                }
                case 48: 
                case 90: {
                    buffer.append(' ');
                    buffer.append(scanner.getCurrentTokenSource());
                    buffer.append(' ');
                    break;
                }
                case 37: {
                    if (depth != 1) break;
                    length = buffer.length();
                    typeRef = new char[length];
                    buffer.getChars(0, length, typeRef, 0);
                    try {
                        Signature.createTypeSignature(typeRef, true);
                        buffer = new StringBuffer();
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                default: {
                    buffer.append(scanner.getCurrentTokenSource());
                }
            }
            if (depth >= 0) continue;
            return false;
        } while (depth != 0 && token != 75);
        if (depth == 0) {
            length = buffer.length() - 1;
            typeRef = new char[length];
            buffer.getChars(0, length, typeRef, 0);
            try {
                Signature.createTypeSignature(typeRef, true);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private void completeLocalTypes(Binding binding) {
        switch (binding.kind()) {
            case 132: 
            case 516: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)binding;
                this.completeLocalTypes(parameterizedTypeBinding.type);
                TypeBinding[] args = parameterizedTypeBinding.arguments;
                int length = args == null ? 0 : args.length;
                int i = 0;
                while (i < length) {
                    this.completeLocalTypes(args[i]);
                    ++i;
                }
                break;
            }
            case 4: 
            case 1028: {
                TypeBinding typeBinding;
                ReferenceBinding enclosingType;
                LocalTypeBinding localTypeBinding;
                if (binding instanceof LocalTypeBinding && (localTypeBinding = (LocalTypeBinding)binding).constantPoolName() == null) {
                    char[] constantPoolName = this.unitScope.computeConstantPoolName(localTypeBinding);
                    localTypeBinding.setConstantPoolName(constantPoolName);
                }
                if ((enclosingType = (typeBinding = (TypeBinding)binding).enclosingType()) == null) break;
                this.completeLocalTypes(enclosingType);
                break;
            }
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)binding;
                this.completeLocalTypes(arrayBinding.leafComponentType);
            }
            case 260: 
            case 2052: {
                break;
            }
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)binding;
                this.completeLocalTypes(fieldBinding.declaringClass);
                this.completeLocalTypes(fieldBinding.type);
                break;
            }
            case 8: {
                MethodBinding methodBinding = (MethodBinding)binding;
                this.completeLocalTypes(methodBinding.returnType);
                TypeBinding[] parameters = methodBinding.parameters;
                int i = 0;
                int max = parameters == null ? 0 : parameters.length;
                while (i < max) {
                    this.completeLocalTypes(parameters[i]);
                    ++i;
                }
                break;
            }
        }
    }

    public AssistParser getParser() {
        return this.parser;
    }

    private boolean isLocal(ReferenceBinding binding) {
        if (binding instanceof ParameterizedTypeBinding) {
            return this.isLocal(((ParameterizedTypeBinding)binding).type);
        }
        if (!(binding instanceof SourceTypeBinding)) {
            return false;
        }
        if (binding instanceof LocalTypeBinding) {
            return true;
        }
        if (binding instanceof MemberTypeBinding) {
            return this.isLocal(((MemberTypeBinding)binding).enclosingType);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void select(ICompilationUnit sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block33: {
            block31: {
                char[] source = sourceUnit.getContents();
                if (DEBUG) {
                    System.out.print("SELECTION IN ");
                    System.out.print(sourceUnit.getFileName());
                    System.out.print(" FROM ");
                    System.out.print(selectionSourceStart);
                    System.out.print(" TO ");
                    System.out.println(selectionSourceEnd);
                    System.out.println("SELECTION - Source :");
                    System.out.println(source);
                }
                if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
                    return;
                }
                try {
                    try {
                        block32: {
                            this.acceptedAnswer = false;
                            CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
                            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(sourceUnit, result, this.actualSelectionStart, this.actualSelectionEnd);
                            if (parsedUnit != null) {
                                if (DEBUG) {
                                    System.out.println("SELECTION - Diet AST :");
                                    System.out.println(parsedUnit.toString());
                                }
                                if (parsedUnit.currentPackage instanceof SelectionOnPackageReference) {
                                    char[][] tokens = ((SelectionOnPackageReference)parsedUnit.currentPackage).tokens;
                                    this.noProposal = false;
                                    this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
                                    Object var12_11 = null;
                                    break block31;
                                }
                                ImportReference[] imports = parsedUnit.imports;
                                if (imports != null) {
                                    int i = 0;
                                    int length = imports.length;
                                    while (i < length) {
                                        ImportReference importReference = imports[i];
                                        if (importReference instanceof SelectionOnImportReference) {
                                            char[][] tokens = ((SelectionOnImportReference)importReference).tokens;
                                            this.noProposal = false;
                                            this.requestor.acceptPackage(CharOperation.concatWith(tokens, '.'));
                                            this.nameEnvironment.findTypes(CharOperation.concatWith(tokens, '.'), this);
                                            if (!this.acceptedAnswer) {
                                                this.acceptQualifiedTypes();
                                                if (!this.acceptedAnswer) {
                                                    this.nameEnvironment.findTypes(this.selectedIdentifier, this);
                                                    if (!this.acceptedAnswer) {
                                                        this.acceptQualifiedTypes();
                                                    }
                                                }
                                            }
                                            if (this.noProposal && this.problem != null) {
                                                this.requestor.acceptError(this.problem);
                                            }
                                            Object var12_12 = null;
                                            this.reset();
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                                if (parsedUnit.types != null) {
                                    if (this.selectDeclaration(parsedUnit)) {
                                        Object var12_13 = null;
                                        this.reset();
                                        return;
                                    }
                                    this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                                    this.unitScope = parsedUnit.scope;
                                    if (this.unitScope != null) {
                                        try {
                                            this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                            parsedUnit.scope.faultInTypes();
                                            ASTNode node = this.parseBlockStatements(parsedUnit, selectionSourceStart);
                                            if (DEBUG) {
                                                System.out.println("SELECTION - AST :");
                                                System.out.println(parsedUnit.toString());
                                            }
                                            parsedUnit.resolve();
                                            if (node != null) {
                                                this.selectLocalDeclaration(node);
                                            }
                                        }
                                        catch (SelectionNodeFound e) {
                                            if (e.binding == null) break block32;
                                            if (DEBUG) {
                                                System.out.println("SELECTION - Selection binding:");
                                                System.out.println(e.binding.toString());
                                            }
                                            this.selectFrom(e.binding, parsedUnit, e.isDeclaration);
                                        }
                                    }
                                }
                            }
                        }
                        if (!this.acceptedAnswer) {
                            this.nameEnvironment.findTypes(this.selectedIdentifier, this);
                            if (!this.acceptedAnswer) {
                                this.acceptQualifiedTypes();
                            }
                        }
                        if (this.noProposal && this.problem != null) {
                            this.requestor.acceptError(this.problem);
                        }
                        break block33;
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (DEBUG) {
                            System.out.println("Exception caught by SelectionEngine:");
                            e.printStackTrace(System.out);
                        }
                        break block33;
                    }
                    catch (AbortCompilation e) {
                        if (DEBUG) {
                            System.out.println("Exception caught by SelectionEngine:");
                            e.printStackTrace(System.out);
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    this.reset();
                    throw throwable;
                }
            }
            this.reset();
            return;
        }
        Object var12_15 = null;
        this.reset();
    }

    private void selectFrom(Binding binding, CompilationUnitDeclaration parsedUnit, boolean isDeclaration) {
        if (binding instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)binding;
            Binding enclosingElement = typeVariableBinding.declaringElement;
            this.noProposal = false;
            if (enclosingElement instanceof SourceTypeBinding) {
                SourceTypeBinding enclosingType = (SourceTypeBinding)enclosingElement;
                this.requestor.acceptTypeParameter(enclosingType.qualifiedPackageName(), enclosingType.qualifiedSourceName(), typeVariableBinding.sourceName(), false, this.actualSelectionStart, this.actualSelectionEnd);
            } else if (enclosingElement instanceof MethodBinding) {
                MethodBinding enclosingMethod = (MethodBinding)enclosingElement;
                this.requestor.acceptMethodTypeParameter(enclosingMethod.declaringClass.qualifiedPackageName(), enclosingMethod.declaringClass.qualifiedSourceName(), enclosingMethod.selector, enclosingMethod.sourceStart(), enclosingMethod.sourceEnd(), typeVariableBinding.sourceName(), false, this.actualSelectionStart, this.actualSelectionEnd);
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof ReferenceBinding) {
            ReferenceBinding typeBinding = (ReferenceBinding)binding;
            if (typeBinding instanceof ProblemReferenceBinding) {
                typeBinding = ((ProblemReferenceBinding)typeBinding).original;
            }
            if (typeBinding == null) {
                return;
            }
            if (this.isLocal(typeBinding) && this.requestor instanceof SelectionRequestor) {
                this.noProposal = false;
                if (typeBinding.isParameterizedType() || typeBinding.isRawType()) {
                    this.completeLocalTypes(typeBinding);
                }
                ((SelectionRequestor)this.requestor).acceptLocalType(typeBinding);
            } else {
                this.noProposal = false;
                char[] genericTypeSignature = null;
                if (typeBinding.isParameterizedType() || typeBinding.isRawType()) {
                    this.completeLocalTypes(typeBinding);
                    genericTypeSignature = typeBinding.computeUniqueKey();
                }
                if (typeBinding.isAnnotationType()) {
                    this.requestor.acceptAnnotation(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false, genericTypeSignature, this.actualSelectionStart, this.actualSelectionEnd);
                } else if (typeBinding.isInterface()) {
                    this.requestor.acceptInterface(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false, genericTypeSignature, this.actualSelectionStart, this.actualSelectionEnd);
                } else if (typeBinding.isEnum()) {
                    this.requestor.acceptEnum(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false, genericTypeSignature, this.actualSelectionStart, this.actualSelectionEnd);
                } else {
                    this.noProposal = false;
                    this.requestor.acceptClass(typeBinding.qualifiedPackageName(), typeBinding.qualifiedSourceName(), false, genericTypeSignature, this.actualSelectionStart, this.actualSelectionEnd);
                }
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof MethodBinding) {
            MethodBinding methodBinding = (MethodBinding)binding;
            TypeBinding[] parameterTypes = methodBinding.original().parameters;
            int length = parameterTypes.length;
            char[][] parameterPackageNames = new char[length][];
            char[][] parameterTypeNames = new char[length][];
            String[] parameterSignatures = new String[length];
            int i = 0;
            while (i < length) {
                parameterPackageNames[i] = parameterTypes[i].qualifiedPackageName();
                parameterTypeNames[i] = parameterTypes[i].qualifiedSourceName();
                parameterSignatures[i] = new String(Engine.getSignature(parameterTypes[i])).replace('/', '.');
                ++i;
            }
            this.noProposal = false;
            ReferenceBinding declaringClass = methodBinding.declaringClass;
            if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                if (methodBinding instanceof ParameterizedMethodBinding) {
                    this.completeLocalTypes(methodBinding);
                }
                ((SelectionRequestor)this.requestor).acceptLocalMethod(methodBinding);
            } else {
                char[] uniqueKey = null;
                if (methodBinding instanceof ParameterizedMethodBinding) {
                    this.completeLocalTypes(methodBinding);
                    uniqueKey = methodBinding.computeUniqueKey();
                }
                this.requestor.acceptMethod(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), declaringClass.enclosingType() == null ? null : new String(Engine.getSignature(declaringClass.enclosingType())), methodBinding.isConstructor() ? declaringClass.sourceName() : methodBinding.selector, parameterPackageNames, parameterTypeNames, parameterSignatures, methodBinding.isConstructor(), isDeclaration, uniqueKey, this.actualSelectionStart, this.actualSelectionEnd);
            }
            this.acceptedAnswer = true;
        } else if (binding instanceof FieldBinding) {
            FieldBinding fieldBinding = (FieldBinding)binding;
            ReferenceBinding declaringClass = fieldBinding.declaringClass;
            if (declaringClass != null) {
                this.noProposal = false;
                if (this.isLocal(declaringClass) && this.requestor instanceof SelectionRequestor) {
                    if (fieldBinding instanceof ParameterizedFieldBinding) {
                        this.completeLocalTypes(fieldBinding.declaringClass);
                    }
                    ((SelectionRequestor)this.requestor).acceptLocalField(fieldBinding);
                } else {
                    char[] uniqueKey = null;
                    if (fieldBinding instanceof ParameterizedFieldBinding) {
                        this.completeLocalTypes(fieldBinding.declaringClass);
                        uniqueKey = fieldBinding.computeUniqueKey();
                    }
                    this.requestor.acceptField(declaringClass.qualifiedPackageName(), declaringClass.qualifiedSourceName(), fieldBinding.name, false, uniqueKey, this.actualSelectionStart, this.actualSelectionEnd);
                }
                this.acceptedAnswer = true;
            }
        } else if (binding instanceof LocalVariableBinding) {
            if (this.requestor instanceof SelectionRequestor) {
                ((SelectionRequestor)this.requestor).acceptLocalVariable((LocalVariableBinding)binding);
                this.acceptedAnswer = true;
            } else {
                this.selectFrom(((LocalVariableBinding)binding).type, parsedUnit, false);
            }
        } else if (binding instanceof ArrayBinding) {
            this.selectFrom(((ArrayBinding)binding).leafComponentType, parsedUnit, false);
        } else if (binding instanceof PackageBinding) {
            PackageBinding packageBinding = (PackageBinding)binding;
            this.noProposal = false;
            this.requestor.acceptPackage(packageBinding.readableName());
            this.acceptedAnswer = true;
        } else if (binding instanceof BaseTypeBinding) {
            this.acceptedAnswer = true;
        }
    }

    private void selectLocalDeclaration(ASTNode node) {
        class Visitor
        extends ASTVisitor {
            final /* synthetic */ SelectionEngine this$0;
            private final /* synthetic */ char[] val$assistIdentifier;

            Visitor(SelectionEngine selectionEngine, char[] cArray) {
                this.this$0 = selectionEngine;
                this.val$assistIdentifier = cArray;
            }

            public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
                if (constructorDeclaration.selector == this.val$assistIdentifier) {
                    if (constructorDeclaration.binding != null) {
                        throw new SelectionNodeFound(constructorDeclaration.binding);
                    }
                    if (constructorDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(constructorDeclaration.modifiers, constructorDeclaration.selector, null, null, null, constructorDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
                if (fieldDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(fieldDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
                if (localTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(localTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
                if (memberTypeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(memberTypeDeclaration.binding);
                }
                return true;
            }

            public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
                if (methodDeclaration.selector == this.val$assistIdentifier) {
                    if (methodDeclaration.binding != null) {
                        throw new SelectionNodeFound(methodDeclaration.binding);
                    }
                    if (methodDeclaration.scope != null) {
                        throw new SelectionNodeFound(new MethodBinding(methodDeclaration.modifiers, methodDeclaration.selector, null, null, null, methodDeclaration.scope.referenceType().binding));
                    }
                }
                return true;
            }

            public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
                if (typeDeclaration.name == this.val$assistIdentifier) {
                    throw new SelectionNodeFound(typeDeclaration.binding);
                }
                return true;
            }
        }
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return;
        }
        if (node instanceof AbstractMethodDeclaration) {
            ((AbstractMethodDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), (ClassScope)null);
        } else {
            ((FieldDeclaration)node).traverse((ASTVisitor)new Visitor(this, assistIdentifier), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectType(ISourceType sourceType, char[] typeName, SourceTypeElementInfo[] topLevelTypes, boolean searchInEnvironment) {
        block22: {
            block20: {
                try {
                    try {
                        block21: {
                            CompilationUnitDeclaration parsedUnit;
                            CompilationResult result;
                            this.acceptedAnswer = false;
                            ISourceType outerType = sourceType;
                            ISourceType parent = sourceType.getEnclosingType();
                            while (true) {
                                if (parent == null) {
                                    result = new CompilationResult(outerType.getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
                                    if (sourceType instanceof SourceTypeElementInfo) break;
                                    Object var16_9 = null;
                                    break block20;
                                }
                                outerType = parent;
                                parent = parent.getEnclosingType();
                            }
                            SourceType typeHandle = (SourceType)((SourceTypeElementInfo)sourceType).getHandle();
                            int flags = 15;
                            if (typeHandle.isAnonymous() || typeHandle.isLocal()) {
                                flags |= 0x20;
                            }
                            if ((parsedUnit = SourceTypeConverter.buildCompilationUnit(topLevelTypes, flags, this.parser.problemReporter(), result)) != null && parsedUnit.types != null) {
                                TypeDeclaration typeDecl;
                                if (DEBUG) {
                                    System.out.println("SELECTION - Diet AST :");
                                    System.out.println(parsedUnit.toString());
                                }
                                if ((typeDecl = new ASTNodeFinder(parsedUnit).findType(typeHandle)) != null) {
                                    FieldDeclaration field = new FieldDeclaration();
                                    int dot = CharOperation.lastIndexOf('.', typeName);
                                    if (dot == -1) {
                                        this.selectedIdentifier = typeName;
                                        field.type = new SelectionOnSingleTypeReference(typeName, -1L);
                                    } else {
                                        char[][] previousIdentifiers = CharOperation.splitOn('.', typeName, 0, dot);
                                        char[] selectionIdentifier = CharOperation.subarray(typeName, dot + 1, typeName.length);
                                        this.selectedIdentifier = selectionIdentifier;
                                        field.type = new SelectionOnQualifiedTypeReference(previousIdentifiers, selectionIdentifier, new long[previousIdentifiers.length + 1]);
                                    }
                                    field.name = "<fakeField>".toCharArray();
                                    typeDecl.fields = new FieldDeclaration[]{field};
                                    this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                                    this.unitScope = parsedUnit.scope;
                                    if (this.unitScope != null) {
                                        try {
                                            this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                            parsedUnit.scope.faultInTypes();
                                            parsedUnit.resolve();
                                        }
                                        catch (SelectionNodeFound e) {
                                            if (e.binding == null) break block21;
                                            if (DEBUG) {
                                                System.out.println("SELECTION - Selection binding :");
                                                System.out.println(e.binding.toString());
                                            }
                                            this.selectFrom(e.binding, parsedUnit, e.isDeclaration);
                                        }
                                    }
                                }
                            }
                        }
                        if (!this.acceptedAnswer && searchInEnvironment && this.selectedIdentifier != null) {
                            this.nameEnvironment.findTypes(typeName, this);
                            if (!this.acceptedAnswer) {
                                this.acceptQualifiedTypes();
                            }
                        }
                        if (this.noProposal && this.problem != null) {
                            this.requestor.acceptError(this.problem);
                        }
                        break block22;
                    }
                    catch (AbortCompilation abortCompilation) {}
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var16_10 = null;
                    this.reset();
                    throw throwable;
                }
            }
            this.reset();
            return;
        }
        Object var16_11 = null;
        this.reset();
    }

    private boolean selectDeclaration(CompilationUnitDeclaration compilationUnit) {
        char[] assistIdentifier = this.getParser().assistIdentifier();
        if (assistIdentifier == null) {
            return false;
        }
        ImportReference currentPackage = compilationUnit.currentPackage;
        char[] packageName = currentPackage == null ? new char[]{} : CharOperation.concatWith(currentPackage.tokens, '.');
        TypeDeclaration[] types = compilationUnit.types;
        int i = 0;
        int length = types == null ? 0 : types.length;
        while (i < length) {
            if (this.selectDeclaration(types[i], assistIdentifier, packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean selectDeclaration(TypeDeclaration typeDeclaration, char[] assistIdentifier, char[] packageName) {
        if (typeDeclaration.name == assistIdentifier) {
            char[] qualifiedSourceName = null;
            TypeDeclaration enclosingType = typeDeclaration;
            while (enclosingType != null) {
                qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                enclosingType = enclosingType.enclosingType;
            }
            switch (typeDeclaration.kind()) {
                case 1: {
                    this.requestor.acceptClass(packageName, qualifiedSourceName, true, null, this.actualSelectionStart, this.actualSelectionEnd);
                    break;
                }
                case 2: {
                    this.requestor.acceptInterface(packageName, qualifiedSourceName, true, null, this.actualSelectionStart, this.actualSelectionEnd);
                    break;
                }
                case 3: {
                    this.requestor.acceptEnum(packageName, qualifiedSourceName, true, null, this.actualSelectionStart, this.actualSelectionEnd);
                    break;
                }
                case 4: {
                    this.requestor.acceptAnnotation(packageName, qualifiedSourceName, true, null, this.actualSelectionStart, this.actualSelectionEnd);
                }
            }
            this.noProposal = false;
            return true;
        }
        TypeDeclaration[] memberTypes = typeDeclaration.memberTypes;
        int i = 0;
        int length = memberTypes == null ? 0 : memberTypes.length;
        while (i < length) {
            if (this.selectDeclaration(memberTypes[i], assistIdentifier, packageName)) {
                return true;
            }
            ++i;
        }
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i2 = 0;
        int length2 = fields == null ? 0 : fields.length;
        while (i2 < length2) {
            if (fields[i2].name == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                this.requestor.acceptField(packageName, qualifiedSourceName, fields[i2].name, true, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            ++i2;
        }
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int i3 = 0;
        int length3 = methods == null ? 0 : methods.length;
        while (i3 < length3) {
            AbstractMethodDeclaration method = methods[i3];
            if (method.selector == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                this.requestor.acceptMethod(packageName, qualifiedSourceName, null, method.selector, null, null, null, method.isConstructor(), true, null, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            TypeParameter[] methodTypeParameters = method.typeParameters();
            int j = 0;
            int length22 = methodTypeParameters == null ? 0 : methodTypeParameters.length;
            while (j < length22) {
                TypeParameter methodTypeParameter = methodTypeParameters[j];
                if (methodTypeParameter.name == assistIdentifier) {
                    char[] qualifiedSourceName = null;
                    TypeDeclaration enclosingType = typeDeclaration;
                    while (enclosingType != null) {
                        qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                        enclosingType = enclosingType.enclosingType;
                    }
                    this.requestor.acceptMethodTypeParameter(packageName, qualifiedSourceName, method.selector, method.sourceStart, method.sourceEnd, methodTypeParameter.name, true, this.actualSelectionStart, this.actualSelectionEnd);
                    this.noProposal = false;
                    return true;
                }
                ++j;
            }
            ++i3;
        }
        TypeParameter[] typeParameters = typeDeclaration.typeParameters;
        int i4 = 0;
        int length4 = typeParameters == null ? 0 : typeParameters.length;
        while (i4 < length4) {
            TypeParameter typeParameter = typeParameters[i4];
            if (typeParameter.name == assistIdentifier) {
                char[] qualifiedSourceName = null;
                TypeDeclaration enclosingType = typeDeclaration;
                while (enclosingType != null) {
                    qualifiedSourceName = CharOperation.concat(enclosingType.name, qualifiedSourceName, '.');
                    enclosingType = enclosingType.enclosingType;
                }
                this.requestor.acceptTypeParameter(packageName, qualifiedSourceName, typeParameter.name, true, this.actualSelectionStart, this.actualSelectionEnd);
                this.noProposal = false;
                return true;
            }
            ++i4;
        }
        return false;
    }
}

