/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;

public abstract class RuntimeParameterAnnotations
extends Attribute {
    private List parameterAnnotations;
    private boolean visible;
    private boolean inflated = false;
    private byte[] annotation_data;

    public RuntimeParameterAnnotations(byte attrid, boolean visible, int nameIdx, int len, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.parameterAnnotations = new ArrayList();
    }

    public RuntimeParameterAnnotations(byte attrid, boolean visible, int nameIdx, int len, byte[] data, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.parameterAnnotations = new ArrayList();
        this.annotation_data = data;
    }

    public final void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        this.writeAnnotations(dos);
    }

    public Attribute copy(ConstantPool constant_pool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List getParameterAnnotations() {
        if (!this.inflated) {
            this.inflate();
        }
        return this.parameterAnnotations;
    }

    public Annotation[] getAnnotationsOnParameter(int parameterIndex) {
        if (!this.inflated) {
            this.inflate();
        }
        return (Annotation[])this.parameterAnnotations.get(parameterIndex);
    }

    public boolean areVisible() {
        return this.visible;
    }

    protected void readParameterAnnotations(DataInputStream dis, ConstantPool cpool) throws IOException {
        this.annotation_data = new byte[this.length];
        dis.read(this.annotation_data, 0, this.length);
    }

    private void inflate() {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int numParameters = dis.readUnsignedByte();
            int i = 0;
            while (i < numParameters) {
                int numAnnotations = dis.readUnsignedShort();
                Annotation[] annotations = new Annotation[numAnnotations];
                int j = 0;
                while (j < numAnnotations) {
                    annotations[j] = Annotation.read(dis, this.getConstantPool(), this.visible);
                    ++j;
                }
                this.parameterAnnotations.add(annotations);
                ++i;
            }
            this.inflated = true;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unabled to inflate annotation data, badly formed?");
        }
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        if (!this.inflated) {
            dos.write(this.annotation_data, 0, this.length);
        } else {
            dos.writeByte(this.parameterAnnotations.size());
            int i = 0;
            while (i < this.parameterAnnotations.size()) {
                Annotation[] annotations = (Annotation[])this.parameterAnnotations.get(i);
                dos.writeShort(annotations.length);
                int j = 0;
                while (j < annotations.length) {
                    annotations[j].dump(dos);
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean isInflated() {
        return this.inflated;
    }

    public String toString() {
        return "Runtime" + (this.visible ? "Visible" : "Invisible") + "ParameterAnnotations [" + (this.inflated ? "inflated" : "not yet inflated") + "]";
    }
}

