/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.res;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class XPATHErrorResources
extends PropertyResourceBundle {
    public static final String ERROR_SUFFIX = "ER";
    public static final String WARNING_SUFFIX = "WR";
    public static final int ERROR0000 = 0;
    public static final int ER_CURRENT_NOT_ALLOWED_IN_MATCH = 1;
    public static final int ER_CURRENT_TAKES_NO_ARGS = 2;
    public static final int ER_DOCUMENT_REPLACED = 3;
    public static final int ER_CONTEXT_HAS_NO_OWNERDOC = 4;
    public static final int ER_LOCALNAME_HAS_TOO_MANY_ARGS = 5;
    public static final int ER_NAMESPACEURI_HAS_TOO_MANY_ARGS = 6;
    public static final int ER_NORMALIZESPACE_HAS_TOO_MANY_ARGS = 7;
    public static final int ER_NUMBER_HAS_TOO_MANY_ARGS = 8;
    public static final int ER_NAME_HAS_TOO_MANY_ARGS = 9;
    public static final int ER_STRING_HAS_TOO_MANY_ARGS = 10;
    public static final int ER_STRINGLENGTH_HAS_TOO_MANY_ARGS = 11;
    public static final int ER_TRANSLATE_TAKES_3_ARGS = 12;
    public static final int ER_UNPARSEDENTITYURI_TAKES_1_ARG = 13;
    public static final int ER_NAMESPACEAXIS_NOT_IMPLEMENTED = 14;
    public static final int ER_UNKNOWN_AXIS = 15;
    public static final int ER_UNKNOWN_MATCH_OPERATION = 16;
    public static final int ER_INCORRECT_ARG_LENGTH = 17;
    public static final int ER_CANT_CONVERT_TO_NUMBER = 18;
    public static final int ER_CANT_CONVERT_TO_NODELIST = 19;
    public static final int ER_CANT_CONVERT_TO_MUTABLENODELIST = 20;
    public static final int ER_CANT_CONVERT_TO_TYPE = 21;
    public static final int ER_EXPECTED_MATCH_PATTERN = 22;
    public static final int ER_COULDNOT_GET_VAR_NAMED = 23;
    public static final int ER_UNKNOWN_OPCODE = 24;
    public static final int ER_EXTRA_ILLEGAL_TOKENS = 25;
    public static final int ER_EXPECTED_DOUBLE_QUOTE = 26;
    public static final int ER_EXPECTED_SINGLE_QUOTE = 27;
    public static final int ER_EMPTY_EXPRESSION = 28;
    public static final int ER_EXPECTED_BUT_FOUND = 29;
    public static final int ER_INCORRECT_PROGRAMMER_ASSERTION = 30;
    public static final int ER_BOOLEAN_ARG_NO_LONGER_OPTIONAL = 31;
    public static final int ER_FOUND_COMMA_BUT_NO_PRECEDING_ARG = 32;
    public static final int ER_FOUND_COMMA_BUT_NO_FOLLOWING_ARG = 33;
    public static final int ER_PREDICATE_ILLEGAL_SYNTAX = 34;
    public static final int ER_ILLEGAL_AXIS_NAME = 35;
    public static final int ER_UNKNOWN_NODETYPE = 36;
    public static final int ER_PATTERN_LITERAL_NEEDS_BE_QUOTED = 37;
    public static final int ER_COULDNOT_BE_FORMATTED_TO_NUMBER = 38;
    public static final int ER_COULDNOT_CREATE_XMLPROCESSORLIAISON = 39;
    public static final int ER_DIDNOT_FIND_XPATH_SELECT_EXP = 40;
    public static final int ER_COULDNOT_FIND_ENDOP_AFTER_OPLOCATIONPATH = 41;
    public static final int ER_ERROR_OCCURED = 42;
    public static final int ER_ILLEGAL_VARIABLE_REFERENCE = 43;
    public static final int ER_AXES_NOT_ALLOWED = 44;
    public static final int ER_KEY_HAS_TOO_MANY_ARGS = 45;
    public static final int ER_COUNT_TAKES_1_ARG = 46;
    public static final int ER_COULDNOT_FIND_FUNCTION = 47;
    public static final int ER_UNSUPPORTED_ENCODING = 48;
    public static final int ER_PROBLEM_IN_DTM_NEXTSIBLING = 49;
    public static final int ER_CANNOT_WRITE_TO_EMPTYNODELISTIMPL = 50;
    public static final int ER_SETDOMFACTORY_NOT_SUPPORTED = 51;
    public static final int ER_PREFIX_MUST_RESOLVE = 52;
    public static final int ER_PARSE_NOT_SUPPORTED = 53;
    public static final int ER_CREATEDOCUMENT_NOT_SUPPORTED = 54;
    public static final int ER_CHILD_HAS_NO_OWNER_DOCUMENT = 55;
    public static final int ER_CHILD_HAS_NO_OWNER_DOCUMENT_ELEMENT = 56;
    public static final int ER_SAX_API_NOT_HANDLED = 57;
    public static final int ER_IGNORABLE_WHITESPACE_NOT_HANDLED = 58;
    public static final int ER_DTM_CANNOT_HANDLE_NODES = 59;
    public static final int ER_XERCES_CANNOT_HANDLE_NODES = 60;
    public static final int ER_XERCES_PARSE_ERROR_DETAILS = 61;
    public static final int ER_XERCES_PARSE_ERROR = 62;
    public static final int ER_CANT_OUTPUT_TEXT_BEFORE_DOC = 63;
    public static final int ER_CANT_HAVE_MORE_THAN_ONE_ROOT = 64;
    public static final int ER_INVALID_UTF16_SURROGATE = 65;
    public static final int ER_OIERROR = 66;
    public static final int ER_CANNOT_CREATE_URL = 67;
    public static final int ER_XPATH_READOBJECT = 68;
    public static final int ER_FUNCTION_TOKEN_NOT_FOUND = 69;
    public static final int ER_ARG_LOCALNAME_NULL = 70;
    public static final int ER_CANNOT_DEAL_XPATH_TYPE = 71;
    public static final int ER_NODESET_NOT_MUTABLE = 72;
    public static final int ER_NODESETDTM_NOT_MUTABLE = 73;
    public static final int ER_VAR_NOT_RESOLVABLE = 74;
    public static final int ER_NULL_ERROR_HANDLER = 75;
    public static final int ER_PROG_ASSERT_UNKNOWN_OPCODE = 76;
    public static final int ER_ZERO_OR_ONE = 77;
    public static final int ER_RTF_NOT_SUPPORTED_XRTREEFRAGSELECTWRAPPER = 78;
    public static final int ER_ASNODEITERATOR_NOT_SUPPORTED_XRTREEFRAGSELECTWRAPPER = 79;
    public static final int ER_FSB_NOT_SUPPORTED_XSTRINGFORCHARS = 80;
    public static final int ER_COULD_NOT_FIND_VAR = 81;
    public static final int ER_XSTRINGFORCHARS_CANNOT_TAKE_STRING = 82;
    public static final int ER_FASTSTRINGBUFFER_CANNOT_BE_NULL = 83;
    public static final int ER_TWO_OR_THREE = 84;
    public static final int ER_VARIABLE_ACCESSED_BEFORE_BIND = 85;
    public static final int ER_FSB_CANNOT_TAKE_STRING = 86;
    public static final int ER_SETTING_WALKER_ROOT_TO_NULL = 87;
    public static final int ER_NODESETDTM_CANNOT_ITERATE = 88;
    public static final int ER_NODESET_CANNOT_ITERATE = 89;
    public static final int ER_NODESETDTM_CANNOT_INDEX = 90;
    public static final int ER_NODESET_CANNOT_INDEX = 91;
    public static final int ER_CANNOT_CALL_SETSHOULDCACHENODE = 92;
    public static final int ER_ONLY_ALLOWS = 93;
    public static final int ER_UNKNOWN_STEP = 94;
    public static final int ER_EXPECTED_REL_LOC_PATH = 95;
    public static final int ER_EXPECTED_LOC_PATH = 96;
    public static final int ER_EXPECTED_LOC_STEP = 97;
    public static final int ER_EXPECTED_NODE_TEST = 98;
    public static final int ER_EXPECTED_STEP_PATTERN = 99;
    public static final int ER_EXPECTED_REL_PATH_PATTERN = 100;
    public static final int ER_ARG_LOCALNAME_INVALID = 101;
    public static final int ER_ARG_PREFIX_INVALID = 102;
    public static final int ER_CANT_CONVERT_TO_BOOLEAN = 103;
    public static final int ER_CANT_CONVERT_TO_SINGLENODE = 104;
    public static final int ER_CANT_GET_SNAPSHOT_LENGTH = 105;
    public static final int ER_NON_ITERATOR_TYPE = 106;
    public static final int ER_DOC_MUTATED = 107;
    public static final int ER_INVALID_XPATH_TYPE = 108;
    public static final int ER_EMPTY_XPATH_RESULT = 109;
    public static final int ER_INCOMPATIBLE_TYPES = 110;
    public static final int ER_NULL_RESOLVER = 111;
    public static final int ER_CANT_CONVERT_TO_STRING = 112;
    public static final int ER_NON_SNAPSHOT_TYPE = 113;
    public static final int ER_WRONG_DOCUMENT = 114;
    public static final int ER_WRONG_NODETYPE = 115;
    public static final int ER_XPATH_ERROR = 116;
    public static final int WG_LOCALE_NAME_NOT_HANDLED = 1;
    public static final int WG_PROPERTY_NOT_SUPPORTED = 2;
    public static final int WG_DONT_DO_ANYTHING_WITH_NS = 3;
    public static final int WG_SECURITY_EXCEPTION = 4;
    public static final int WG_QUO_NO_LONGER_DEFINED = 5;
    public static final int WG_NEED_DERIVED_OBJECT_TO_IMPLEMENT_NODETEST = 6;
    public static final int WG_FUNCTION_TOKEN_NOT_FOUND = 7;
    public static final int WG_COULDNOT_FIND_FUNCTION = 8;
    public static final int WG_CANNOT_MAKE_URL_FROM = 9;
    public static final int WG_EXPAND_ENTITIES_NOT_SUPPORTED = 10;
    public static final int WG_ILLEGAL_VARIABLE_REFERENCE = 11;
    public static final int WG_UNSUPPORTED_ENCODING = 12;
    public static final String BAD_CODE = "BAD_CODE";
    public static final String FORMAT_FAILED = "FORMAT_FAILED";
    public static final String ERROR_RESOURCES = "org.apache.xpath.res.XPATHErrorResources";
    public static final String ERROR_STRING = "#error";
    public static final String ERROR_HEADER = "Error: ";
    public static final String WARNING_HEADER = "Warning: ";
    public static final String XSL_HEADER = "XSL ";
    public static final String XML_HEADER = "XML ";
    public static final String QUERY_HEADER = "PATTERN ";

    public XPATHErrorResources() throws IOException {
        super((InputStream)null);
    }

    public XPATHErrorResources(InputStream is) throws IOException {
        super(is);
    }

    public static final ResourceBundle loadResourceBundle(String className) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        String suffix = XPATHErrorResources.getResourceSuffix(locale);
        try {
            return ResourceBundle.getBundle(className + suffix, locale);
        }
        catch (MissingResourceException e) {
            try {
                return ResourceBundle.getBundle(className, new Locale("en", "US"));
            }
            catch (MissingResourceException e2) {
                throw new MissingResourceException("Could not load any resource bundles.", className, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String suffix = "_" + locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("TW")) {
            suffix = suffix + "_" + country;
        }
        return suffix;
    }

    public static String getMessageKey(int errorCode) {
        DecimalFormat df = new DecimalFormat("0000");
        return ERROR_SUFFIX + df.format(errorCode);
    }

    public static String getWarningKey(int errorCode) {
        DecimalFormat df = new DecimalFormat("0000");
        return WARNING_SUFFIX + df.format(errorCode);
    }

    public static String getMKey(int errorCode) {
        DecimalFormat df = new DecimalFormat("0000");
        return ERROR_SUFFIX + df.format(errorCode);
    }

    public static String getWKey(int errorCode) {
        DecimalFormat df = new DecimalFormat("0000");
        return WARNING_SUFFIX + df.format(errorCode);
    }
}

