/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLStringConstructor;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public final class XSLAttribute
extends XSLStringConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private boolean disable = false;

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.NAMESPACE) {
                string2 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.SAXON_DISABLE_OUTPUT_ESCAPING) {
                string3 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        this.attributeName = this.makeAttributeValueTemplate(string);
        if (this.attributeName instanceof StringValue && !Name.isQName(string)) {
            this.compileError("Attribute name is not a valid QName");
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        this.disable = string3 != null && string3.equals("yes");
    }

    public void validate() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLAttributeSet)) {
            this.checkWithinTemplate();
        }
        this.optimize();
    }

    public void process(Context context) throws TransformerException {
        String string;
        short s;
        String string2 = this.attributeName.evaluateAsString(context);
        Controller controller = context.getController();
        NamePool namePool = controller.getNamePool();
        if (!Name.isQName(string2)) {
            controller.reportRecoverableError("Invalid attribute name: " + string2, this);
            return;
        }
        if (string2.equals("xmlns") || string2.length() > 6 && string2.substring(0, 6).equals("xmlns:")) {
            controller.reportRecoverableError("Invalid attribute name: " + string2, this);
            return;
        }
        String string3 = Name.getPrefix(string2);
        if (this.namespace == null) {
            if (string3.equals("")) {
                s = 0;
            } else {
                try {
                    s = this.getURICodeForPrefix(string3);
                }
                catch (NamespaceException namespaceException) {
                    throw this.styleError(namespaceException.getMessage());
                }
            }
        } else {
            string = this.namespace.evaluateAsString(context);
            if (string.equals("")) {
                string3 = "";
            } else if (string3.equals("") && (string3 = this.getPrefixForURI(string)) == null) {
                string3 = "ns0";
            }
            s = namePool.allocateCodeForURI(string);
        }
        string = Name.getLocalName(string2);
        int n = namePool.allocate(string3, s, string);
        Outputter outputter = controller.getOutputter();
        if ((n >> 20 & 0xFF) != 0) {
            n = outputter.checkAttributePrefix(n);
        }
        outputter.writeAttribute(n, this.expandChildren(context), this.disable);
    }
}

