/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeReference;
import com.icl.saxon.expr.AxisExpression;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.RootExpression;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Axis;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;

public class PathExpression
extends NodeSetExpression {
    private Expression start;
    private Step step;
    int dependencies = -1;

    public PathExpression(Expression expression, Step step) {
        this.start = expression;
        this.step = step;
    }

    public Expression simplify() throws XPathException {
        this.start = this.start.simplify();
        this.step = this.step.simplify();
        if (this.start instanceof EmptyNodeSet) {
            return this.start;
        }
        if (this.step == null) {
            return new EmptyNodeSet();
        }
        byte by = this.step.getAxis();
        if (this.start instanceof RootExpression && by == 9) {
            return new EmptyNodeSet();
        }
        if (this.start instanceof ContextNodeExpression && by == 2 && this.step.getNodeTest() instanceof NameTest && this.step.getNumberOfFilters() == 0) {
            return new AttributeReference(this.step.getNodeTest().getFingerprint());
        }
        if (this.start instanceof ContextNodeExpression && this.step.getNumberOfFilters() == 0) {
            return new AxisExpression(by, this.step.getNodeTest());
        }
        if (by == 3 && this.step.getNumberOfFilters() == 0 && this.start instanceof PathExpression && ((PathExpression)this.start).step.getAxis() == 5 && ((PathExpression)this.start).step.getNumberOfFilters() == 0 && ((PathExpression)this.start).step.getNodeTest() instanceof AnyNodeTest) {
            return new PathExpression(((PathExpression)this.start).start, new Step(4, this.step.getNodeTest()));
        }
        return this;
    }

    public int getDependencies() {
        if (this.dependencies == -1) {
            this.dependencies = this.start.getDependencies();
            Expression[] expressionArray = this.step.getFilters();
            int n = 0;
            while (n < this.step.getNumberOfFilters()) {
                Expression expression = expressionArray[n];
                this.dependencies |= expression.getDependencies() & 0x45;
                ++n;
            }
        }
        return this.dependencies;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression;
            Expression expression2 = this.start.reduce(n, context);
            Step step = new Step(this.step.getAxis(), this.step.getNodeTest());
            Expression[] expressionArray = this.step.getFilters();
            int n2 = 0;
            while (n2 < this.step.getNumberOfFilters()) {
                expression = expressionArray[n2];
                Expression expression3 = expression.reduce(n & 0x45, context);
                step.addFilter(expression3);
                ++n2;
            }
            expression = new PathExpression(expression2, step);
            expression.setStaticContext(this.getStaticContext());
            return expression.simplify();
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if ((this.getDependencies() & 0x45) != 0) {
            return this.reduce(69, context).enumerate(context, bl);
        }
        PathEnumeration pathEnumeration = new PathEnumeration(this.start, context);
        if (bl && !pathEnumeration.isSorted()) {
            NodeOrderComparer nodeOrderComparer = this.start instanceof SingletonExpression ? LocalOrderComparer.getInstance() : context.getController();
            NodeSetExtent nodeSetExtent = new NodeSetExtent(pathEnumeration, nodeOrderComparer);
            nodeSetExtent.sort();
            return nodeSetExtent.enumerate();
        }
        return pathEnumeration;
    }

    private class PathEnumeration
    implements NodeEnumeration {
        private Expression thisStart;
        private NodeEnumeration base = null;
        private NodeEnumeration thisStep = null;
        private NodeInfo next = null;
        private Context context;

        public PathEnumeration(Expression expression, Context context) throws XPathException {
            this.thisStart = expression;
            this.context = context.newContext();
            this.base = expression.enumerate(this.context, false);
            this.next = this.getNextNode();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public NodeInfo nextElement() throws XPathException {
            NodeInfo nodeInfo = this.next;
            this.next = this.getNextNode();
            return nodeInfo;
        }

        /*
         * Unable to fully structure code
         */
        private NodeInfo getNextNode() throws XPathException {
            if (this.thisStep == null || !this.thisStep.hasMoreElements()) ** GOTO lbl7
            return this.thisStep.nextElement();
lbl-1000:
            // 1 sources

            {
                var1_1 = this.base.nextElement();
                this.thisStep = PathExpression.access$000(PathExpression.this).enumerate(var1_1, this.context);
                if (!this.thisStep.hasMoreElements()) continue;
                return this.thisStep.nextElement();
lbl7:
                // 2 sources

                ** while (this.base.hasMoreElements())
            }
lbl8:
            // 1 sources

            return null;
        }

        public boolean isSorted() {
            return Axis.isForwards[PathExpression.this.step.getAxis()] && (this.thisStart instanceof SingletonExpression || this.base.isSorted() && this.base.isPeer() && Axis.isSubtreeAxis[PathExpression.this.step.getAxis()]);
        }

        public boolean isReverseSorted() {
            return this.thisStart instanceof SingletonExpression && Axis.isReverse[PathExpression.this.step.getAxis()];
        }

        public boolean isPeer() {
            return this.base.isPeer() && Axis.isPeerAxis[PathExpression.this.step.getAxis()];
        }
    }
}

