/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.python.core.ClassDictInit;
import org.python.core.DictFuncs;
import org.python.core.Py;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyDictionary
extends PyObject
implements ClassDictInit {
    protected static PyObject __methods__;
    protected Hashtable table;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__len__", (PyObject)new DictFuncs("__len__", 1, 0));
        dict.__setitem__("__nonzero__", (PyObject)new DictFuncs("__nonzero__", 2, 0));
        dict.__setitem__("copy", (PyObject)new DictFuncs("copy", 3, 0));
        dict.__setitem__("clear", (PyObject)new DictFuncs("clear", 4, 0));
        dict.__setitem__("items", (PyObject)new DictFuncs("items", 5, 0));
        dict.__setitem__("keys", (PyObject)new DictFuncs("keys", 6, 0));
        dict.__setitem__("values", (PyObject)new DictFuncs("values", 7, 0));
        dict.__setitem__("popitem", (PyObject)new DictFuncs("popitem", 8, 0));
        dict.__setitem__("__cmp__", (PyObject)new DictFuncs("__cmp__", 11, 1));
        dict.__setitem__("has_key", (PyObject)new DictFuncs("has_key", 12, 1));
        dict.__setitem__("get", (PyObject)new DictFuncs("get", 13, 1, 2));
        dict.__setitem__("update", (PyObject)new DictFuncs("update", 14, 1));
        dict.__setitem__("__finditem__", null);
        dict.__setitem__("__setitem__", null);
        dict.__setitem__("__delitem__", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("hashCode", null);
        dict.__setitem__("classDictInit", null);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'dict' object";
    }

    public PyObject __findattr__(String name) {
        if (name.equals("__methods__")) {
            PyList mlist = (PyList)__methods__;
            PyObject[] methods = new PyString[mlist.length];
            int i = 0;
            while (i < mlist.length) {
                methods[i] = (PyString)mlist.list[i];
                ++i;
            }
            return new PyList(methods);
        }
        return super.__findattr__(name);
    }

    public int __len__() {
        return this.table.size();
    }

    public boolean __nonzero__() {
        return this.table.size() != 0;
    }

    public PyObject __finditem__(int index) {
        throw Py.TypeError("loop over non-sequence");
    }

    public PyObject __finditem__(PyObject key) {
        return (PyObject)this.table.get(key);
    }

    public void __setitem__(PyObject key, PyObject value) {
        this.table.put(key, value);
    }

    public void __delitem__(PyObject key) {
        Object ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key.toString());
        }
    }

    public String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        Enumeration ek = this.table.keys();
        Enumeration ev = this.table.elements();
        int n = this.table.size();
        StringBuffer buf = new StringBuffer("{");
        int i = 0;
        while (i < n) {
            buf.append(((PyObject)ek.nextElement()).__repr__().toString());
            buf.append(": ");
            buf.append(((PyObject)ev.nextElement()).__repr__().toString());
            if (i < n - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    public int __cmp__(PyObject ob_other) {
        int bn;
        if (ob_other.__class__ != this.__class__) {
            return -2;
        }
        PyDictionary other = (PyDictionary)ob_other;
        int an = this.table.size();
        if (an < (bn = other.table.size())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = other.keys();
        akeys.sort();
        bkeys.sort();
        int i = 0;
        while (i < bn) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.get(i);
            int c = akey._cmp(bkey = bkeys.get(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            c = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    public boolean has_key(PyObject key) {
        return this.table.containsKey(key);
    }

    public PyObject get(PyObject key, PyObject default_object) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            return default_object;
        }
        return o;
    }

    public PyObject get(PyObject key) {
        return this.get(key, Py.None);
    }

    public PyDictionary copy() {
        return new PyDictionary((Hashtable)this.table.clone());
    }

    public void clear() {
        this.table.clear();
    }

    public void update(PyDictionary d) {
        Hashtable otable = d.table;
        Enumeration ek = otable.keys();
        Enumeration ev = otable.elements();
        int n = otable.size();
        int i = 0;
        while (i < n) {
            this.table.put(ek.nextElement(), ev.nextElement());
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(PyStringMap d) {
        PyObject key;
        PyList keys = d.keys();
        int i = 0;
        while ((key = ((PyObject)keys).__finditem__(i)) != null) {
            void var3_4;
            this.__setitem__((PyObject)var3_4, d.__getitem__((PyObject)var3_4));
            ++i;
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        PyObject o = this.__finditem__(key);
        if (o == null) {
            o = failobj;
            this.__setitem__(key, o);
        }
        return o;
    }

    public PyObject popitem() {
        Enumeration keys = this.table.keys();
        if (!keys.hasMoreElements()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        PyObject key = (PyObject)keys.nextElement();
        PyObject val = (PyObject)this.table.get(key);
        this.table.remove(key);
        return new PyTuple(new PyObject[]{key, val});
    }

    public PyList items() {
        Enumeration ek = this.table.keys();
        Enumeration ev = this.table.elements();
        int n = this.table.size();
        Vector<PyTuple> l = new Vector<PyTuple>(n);
        int i = 0;
        while (i < n) {
            l.addElement(new PyTuple(new PyObject[]{(PyObject)ek.nextElement(), (PyObject)ev.nextElement()}));
            ++i;
        }
        return new PyList(l);
    }

    public PyList keys() {
        Enumeration e = this.table.keys();
        int n = this.table.size();
        Vector l = new Vector(n);
        int i = 0;
        while (i < n) {
            l.addElement(e.nextElement());
            ++i;
        }
        return new PyList(l);
    }

    public PyList values() {
        Enumeration e = this.table.elements();
        int n = this.table.size();
        Vector l = new Vector(n);
        int i = 0;
        while (i < n) {
            l.addElement(e.nextElement());
            ++i;
        }
        return new PyList(l);
    }

    public int hashCode() {
        throw Py.TypeError("unhashable type");
    }

    public PyDictionary() {
        this(new Hashtable());
    }

    public PyDictionary(Hashtable t) {
        this.table = t;
    }

    public PyDictionary(PyObject[] elements) {
        this();
        int i = 0;
        while (i < elements.length) {
            this.table.put(elements[i], elements[i + 1]);
            i += 2;
        }
    }

    static {
        PyList list = new PyList();
        String[] methods = new String[]{"clear", "copy", "get", "has_key", "items", "keys", "update", "values", "setdefault"};
        int i = 0;
        while (i < methods.length) {
            list.append(new PyString(methods[i]));
            ++i;
        }
        __methods__ = list;
    }
}

