/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.nio.file.FileSystems;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileHandler;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.internal.filesystem.local.NativeHandler;
import org.eclipse.core.internal.filesystem.local.nio.DefaultHandler;
import org.eclipse.core.internal.filesystem.local.nio.DosHandler;
import org.eclipse.core.internal.filesystem.local.nio.PosixHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileHandler;
import org.eclipse.core.internal.filesystem.local.unix.UnixFileNatives;

public class LocalFileNativesManager {
    private static NativeHandler HANDLER;
    private static boolean USING_NATIVES;

    static {
        boolean nativesAllowed = Boolean.valueOf(System.getProperty("eclipse.filesystem.useNatives", "true"));
        if (nativesAllowed && UnixFileNatives.isUsingNatives()) {
            HANDLER = new UnixFileHandler();
            USING_NATIVES = true;
        } else if (nativesAllowed && LocalFileNatives.isUsingNatives()) {
            HANDLER = new LocalFileHandler();
            USING_NATIVES = true;
        } else {
            Set<String> views = FileSystems.getDefault().supportedFileAttributeViews();
            HANDLER = views.contains("posix") ? new PosixHandler() : (views.contains("dos") ? new DosHandler() : new DefaultHandler());
        }
    }

    public static int getSupportedAttributes() {
        return HANDLER.getSupportedAttributes();
    }

    public static FileInfo fetchFileInfo(String fileName) {
        return HANDLER.fetchFileInfo(fileName);
    }

    public static boolean putFileInfo(String fileName, IFileInfo info, int options) {
        return HANDLER.putFileInfo(fileName, info, options);
    }

    public static boolean isUsingNatives() {
        return USING_NATIVES;
    }
}

