/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.IfStatement;
import org.aspectj.org.eclipse.jdt.core.dom.ReturnStatement;
import org.aspectj.org.eclipse.jdt.core.dom.ThrowStatement;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.aspectj.org.eclipse.jdt.internal.formatter.Token;
import org.aspectj.org.eclipse.jdt.internal.formatter.TokenTraverser;
import org.aspectj.org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;

public class TokenManager
implements Iterable<Token> {
    private static final Pattern COMMENT_LINE_ANNOTATION_PATTERN = Pattern.compile("^(\\s*\\*?\\s*)(@)");
    private final List<Token> tokens;
    private final String source;
    private final int tabSize;
    private final int tabChar;
    private final boolean wrapWithSpaces;
    final CommentWrapExecutor commentWrapper;
    private HashMap<Integer, Integer> tokenIndexToNLSAlign;
    private List<Token[]> formatOffTagPairs = new ArrayList<Token[]>();
    private int headerEndIndex = 0;
    private TokenTraverser positionInLineCounter = new TokenTraverser(){
        private boolean isNLSTagInLine = false;

        @Override
        protected boolean token(Token traversed, int index) {
            List<Token> internalStructure;
            if (index == this.value) {
                this.isNLSTagInLine = false;
                return false;
            }
            if (traversed.hasNLSTag()) {
                if (!$assertionsDisabled && traversed.tokenType != 64) {
                    throw new AssertionError();
                }
                this.isNLSTagInLine = true;
            }
            if (traversed.getAlign() > 0) {
                this.counter = traversed.getAlign();
            }
            if ((internalStructure = traversed.getInternalStructure()) != null && !internalStructure.isEmpty()) {
                if (!$assertionsDisabled && traversed.tokenType != 1002 && traversed.tokenType != 1003) {
                    throw new AssertionError();
                }
                this.counter = TokenManager.this.commentWrapper.wrapMultiLineComment(traversed, this.counter, true, this.isNLSTagInLine);
            } else {
                this.counter += TokenManager.this.getLength(traversed, this.counter);
            }
            if (this.isSpaceAfter()) {
                ++this.counter;
            }
            return true;
        }
    };

    public TokenManager(List<Token> tokens, String source, DefaultCodeFormatterOptions options) {
        this.tokens = tokens;
        this.source = source;
        this.tabSize = options.tab_size;
        this.tabChar = options.tab_char;
        this.wrapWithSpaces = options.use_tabs_only_for_leading_indentations;
        this.commentWrapper = new CommentWrapExecutor(this, options);
    }

    public TokenManager(List<Token> tokens, TokenManager parent) {
        this.tokens = tokens;
        this.source = parent.source;
        this.tabSize = parent.tabSize;
        this.tabChar = parent.tabChar;
        this.wrapWithSpaces = parent.wrapWithSpaces;
        this.commentWrapper = parent.commentWrapper;
    }

    public Token get(int index) {
        return this.tokens.get(index);
    }

    public int size() {
        return this.tokens.size();
    }

    public void remove(int tokenIndex) {
        this.tokens.remove(tokenIndex);
    }

    public void insert(int tokenIndex, Token token) {
        this.tokens.add(tokenIndex, token);
    }

    public String toString(int tokenIndex) {
        return this.toString(this.get(tokenIndex));
    }

    public String toString(Token token) {
        if (token.isToEscape()) {
            return this.getEscapedTokenString(token);
        }
        return token.toString(this.source);
    }

    public String toString(ASTNode node) {
        return this.source.substring(node.getStartPosition(), node.getStartPosition() + node.getLength());
    }

    public String getSource() {
        return this.source;
    }

    public int indexOf(Token token) {
        int index = this.findIndex(token.originalStart, -1, false);
        if (this.get(index) != token) {
            return -1;
        }
        return index;
    }

    public char charAt(int sourcePosition) {
        return this.source.charAt(sourcePosition);
    }

    public int getSourceLength() {
        return this.source.length();
    }

    public int findIndex(int positionInSource, int tokenType, boolean forward) {
        int index;
        int left = 0;
        int right = this.size() - 1;
        while (left < right) {
            index = (right + left) / 2;
            Token token = this.get(index);
            if (token.originalStart <= positionInSource && positionInSource <= token.originalEnd) {
                left = index;
                break;
            }
            if (token.originalEnd < positionInSource) {
                left = index + 1;
                continue;
            }
            assert (token.originalStart > positionInSource);
            right = index - 1;
        }
        index = left;
        if (!forward && this.get((int)index).originalStart > positionInSource) {
            --index;
        }
        if (forward && this.get((int)index).originalEnd < positionInSource) {
            ++index;
        }
        while (tokenType >= 0 && this.get((int)index).tokenType != tokenType) {
            index += forward ? 1 : -1;
        }
        return index;
    }

    @Override
    public Iterator<Token> iterator() {
        return this.tokens.iterator();
    }

    public boolean isGuardClause(Block node) {
        if (node.statements().size() != 1) {
            return false;
        }
        ASTNode parent = node.getParent();
        if (!(parent instanceof IfStatement) || ((IfStatement)parent).getElseStatement() != null) {
            return false;
        }
        Object statement = node.statements().get(0);
        if (!(statement instanceof ReturnStatement) && !(statement instanceof ThrowStatement)) {
            return false;
        }
        int openBraceIndex = this.firstIndexIn(node, 65);
        return !this.get(openBraceIndex + 1).isComment();
    }

    public int firstIndexIn(ASTNode node, int tokenType) {
        int index = this.findIndex(node.getStartPosition(), tokenType, true);
        assert (this.tokenInside(node, index));
        return index;
    }

    public Token firstTokenIn(ASTNode node, int tokenType) {
        return this.get(this.firstIndexIn(node, tokenType));
    }

    public int lastIndexIn(ASTNode node, int tokenType) {
        int index = this.findIndex(node.getStartPosition() + node.getLength() - 1, tokenType, false);
        assert (this.tokenInside(node, index));
        return index;
    }

    public Token lastTokenIn(ASTNode node, int tokenType) {
        return this.get(this.lastIndexIn(node, tokenType));
    }

    public int firstIndexAfter(ASTNode node, int tokenType) {
        return this.findIndex(node.getStartPosition() + node.getLength(), tokenType, true);
    }

    public Token firstTokenAfter(ASTNode node, int tokenType) {
        return this.get(this.firstIndexAfter(node, tokenType));
    }

    public int firstIndexBefore(ASTNode node, int tokenType) {
        return this.findIndex(node.getStartPosition() - 1, tokenType, false);
    }

    public Token firstTokenBefore(ASTNode node, int tokenType) {
        return this.get(this.firstIndexBefore(node, tokenType));
    }

    public int countLineBreaksBetween(Token previous, Token current) {
        int start = previous != null ? previous.originalEnd + 1 : 0;
        int end = current != null ? current.originalStart : this.source.length();
        return this.countLineBreaksBetween(this.source, start, end);
    }

    public int countLineBreaksBetween(String text, int startPosition, int endPosition) {
        int result = 0;
        int i = startPosition;
        while (i < endPosition) {
            switch (text.charAt(i)) {
                case '\r': {
                    ++result;
                    if (i + 1 >= endPosition || text.charAt(i + 1) != '\n') break;
                    ++i;
                    break;
                }
                case '\n': {
                    ++result;
                    if (i + 1 >= endPosition || text.charAt(i + 1) != '\r') break;
                    ++i;
                }
            }
            ++i;
        }
        return result;
    }

    public int getPositionInLine(int tokenIndex) {
        Token token = this.get(tokenIndex);
        if (token.getAlign() > 0) {
            return this.get(tokenIndex).getAlign();
        }
        int firstTokenIndex = token.getLineBreaksBefore() > 0 ? tokenIndex : this.findFirstTokenInLine(tokenIndex);
        Token firstToken = this.get(firstTokenIndex);
        int startingPosition = this.toIndent(firstToken.getIndent(), firstToken.getWrapPolicy() != null);
        if (firstTokenIndex == tokenIndex) {
            return startingPosition;
        }
        this.positionInLineCounter.value = tokenIndex;
        this.positionInLineCounter.counter = startingPosition;
        this.traverse(firstTokenIndex, this.positionInLineCounter);
        return this.positionInLineCounter.counter;
    }

    public int findSourcePositionInLine(int position) {
        char c;
        int lineStartPosition = position;
        while (lineStartPosition > 0 && (c = this.charAt(lineStartPosition)) != '\r' && c != '\n') {
            --lineStartPosition;
        }
        int positionInLine = this.getLength(lineStartPosition, position - 1, 0);
        return positionInLine;
    }

    private String getEscapedTokenString(Token token) {
        String text;
        Matcher matcher;
        if (token.getLineBreaksBefore() > 0 && this.charAt(token.originalStart) == '@') {
            return "&#64;" + this.source.substring(token.originalStart + 1, token.originalEnd + 1);
        }
        if (token.tokenType == 0 && (matcher = COMMENT_LINE_ANNOTATION_PATTERN.matcher(text = token.toString(this.source))).find()) {
            return String.valueOf(matcher.group(1)) + "&#64;" + text.substring(matcher.end(2));
        }
        return token.toString(this.source);
    }

    public int getLength(Token token, int startPosition) {
        int length = this.getLength(token.originalStart, token.originalEnd, startPosition);
        if (token.isToEscape()) {
            Matcher matcher;
            if (token.getLineBreaksBefore() > 0 && this.charAt(token.originalStart) == '@') {
                length += 4;
            } else if (token.tokenType == 0 && (matcher = COMMENT_LINE_ANNOTATION_PATTERN.matcher(token.toString(this.source))).find()) {
                length += 4;
            }
        }
        return length;
    }

    public int getLength(int originalStart, int originalEnd, int startPosition) {
        int position = startPosition;
        int i = originalStart;
        while (i <= originalEnd) {
            switch (this.source.charAt(i)) {
                case '\t': {
                    if (this.tabSize <= 0) break;
                    position += this.tabSize - position % this.tabSize;
                    break;
                }
                case '\n': 
                case '\r': {
                    position = 0;
                    break;
                }
                default: {
                    ++position;
                }
            }
            ++i;
        }
        return position - startPosition;
    }

    public int toIndent(int indent, boolean isWrapped) {
        if (!(this.tabChar != 1 || isWrapped && this.wrapWithSpaces)) {
            int tab = this.tabSize;
            if (tab <= 0) {
                return 0;
            }
            indent = (indent + tab - 1) / tab * tab;
        }
        return indent;
    }

    public int traverse(int startIndex, TokenTraverser traverser) {
        return traverser.traverse(this.tokens, startIndex);
    }

    public int findFirstTokenInLine(int startIndex) {
        return this.findFirstTokenInLine(startIndex, false, false);
    }

    public int findFirstTokenInLine(int startIndex, boolean includeWraps, boolean includeIndents) {
        Token previous = this.get(startIndex);
        int i = startIndex - 1;
        while (i >= 0) {
            Token token = this.get(i);
            if (token.getLineBreaksAfter() > 0 || previous.getLineBreaksBefore() > 0) {
                boolean include;
                boolean bl = previous.getWrapPolicy() != null && (previous.getWrapPolicy().wrapMode == Token.WrapMode.BLOCK_INDENT ? includeIndents : includeWraps) ? true : (include = false);
                if (!include) {
                    return i + 1;
                }
            }
            previous = token;
            --i;
        }
        return 0;
    }

    private boolean tokenInside(ASTNode node, int index) {
        return this.get((int)index).originalStart >= node.getStartPosition() && this.get((int)index).originalEnd <= node.getStartPosition() + node.getLength();
    }

    public void addNLSAlignIndex(int index, int align) {
        if (this.tokenIndexToNLSAlign == null) {
            this.tokenIndexToNLSAlign = new HashMap();
        }
        this.tokenIndexToNLSAlign.put(index, align);
    }

    public int getNLSAlign(int index) {
        if (this.tokenIndexToNLSAlign == null) {
            return 0;
        }
        Integer align = this.tokenIndexToNLSAlign.get(index);
        return align != null ? align : 0;
    }

    public void setHeaderEndIndex(int headerEndIndex) {
        this.headerEndIndex = headerEndIndex;
    }

    public boolean isInHeader(int tokenIndex) {
        return tokenIndex < this.headerEndIndex;
    }

    public void addDisableFormatTokenPair(Token formatOffTag, Token formatOnTag) {
        this.formatOffTagPairs.add(new Token[]{formatOffTag, formatOnTag});
    }

    public List<Token[]> getDisableFormatTokenPairs() {
        return this.formatOffTagPairs;
    }
}

