/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTMatcher;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotatableType;
import org.aspectj.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;

public class SimpleType
extends AnnotatableType {
    public static final ChildListPropertyDescriptor ANNOTATIONS_PROPERTY = SimpleType.internalAnnotationsPropertyFactory(SimpleType.class);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(SimpleType.class, "name", Name.class, true, false);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private Name typeName = null;

    static {
        ArrayList propertyList = new ArrayList(2);
        SimpleType.createPropertyList(SimpleType.class, propertyList);
        SimpleType.addProperty(NAME_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SimpleType.reapPropertyList(propertyList);
        propertyList = new ArrayList(3);
        SimpleType.createPropertyList(SimpleType.class, propertyList);
        SimpleType.addProperty(ANNOTATIONS_PROPERTY, propertyList);
        SimpleType.addProperty(NAME_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = SimpleType.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        switch (apiLevel) {
            case 2: 
            case 3: 
            case 4: {
                return PROPERTY_DESCRIPTORS;
            }
        }
        return PROPERTY_DESCRIPTORS_8_0;
    }

    SimpleType(AST ast) {
        super(ast);
    }

    @Override
    final ChildListPropertyDescriptor internalAnnotationsProperty() {
        return ANNOTATIONS_PROPERTY;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SimpleType.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ANNOTATIONS_PROPERTY) {
            return this.annotations();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 43;
    }

    @Override
    ASTNode clone0(AST target) {
        SimpleType result = new SimpleType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel >= 8) {
            result.annotations().addAll(ASTNode.copySubtrees(target, this.annotations()));
        }
        result.setName((Name)this.getName().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 8) {
                this.acceptChildren(visitor, this.annotations);
            }
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.typeName == null) {
            SimpleType simpleType = this;
            synchronized (simpleType) {
                if (this.typeName == null) {
                    this.preLazyInit();
                    this.typeName = new SimpleName(this.ast);
                    this.postLazyInit(this.typeName, NAME_PROPERTY);
                }
            }
        }
        return this.typeName;
    }

    public void setName(Name typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.typeName;
        this.preReplaceChild(oldChild, typeName, NAME_PROPERTY);
        this.typeName = typeName;
        this.postReplaceChild(oldChild, typeName, NAME_PROPERTY);
    }

    @Override
    public boolean isVar() {
        String qName;
        this.unsupportedBelow10();
        if (this.typeName == null) {
            this.getName();
        }
        return (qName = this.typeName.getFullyQualifiedName()) != null && qName.equals("var");
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.annotations == null ? 0 : this.annotations.listSize()) + (this.typeName == null ? 0 : this.getName().treeSize());
    }
}

