/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.BindingResolver;
import org.aspectj.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMethodBinding;
import org.aspectj.org.eclipse.jdt.core.dom.ITypeBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IVariableBinding;
import org.aspectj.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclaration;

class RecoveredVariableBinding
implements IVariableBinding {
    private VariableDeclaration variableDeclaration;
    private BindingResolver resolver;

    RecoveredVariableBinding(BindingResolver resolver, VariableDeclaration variableDeclaration) {
        this.resolver = resolver;
        this.variableDeclaration = variableDeclaration;
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        ASTNode parent = this.variableDeclaration.getParent();
        while (parent != null && parent.getNodeType() != 55) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((TypeDeclaration)parent).resolveBinding();
        }
        return null;
    }

    @Override
    public IMethodBinding getDeclaringMethod() {
        ASTNode parent = this.variableDeclaration.getParent();
        while (parent != null && parent.getNodeType() != 31) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((MethodDeclaration)parent).resolveBinding();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.variableDeclaration.getName().getIdentifier();
    }

    @Override
    public ITypeBinding getType() {
        return this.resolver.getTypeBinding(this.variableDeclaration);
    }

    @Override
    public IVariableBinding getVariableDeclaration() {
        return this;
    }

    @Override
    public int getVariableId() {
        return 0;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public boolean isField() {
        return this.variableDeclaration.getParent() instanceof FieldDeclaration;
    }

    @Override
    public boolean isParameter() {
        return this.variableDeclaration instanceof SingleVariableDeclaration;
    }

    @Override
    public IAnnotationBinding[] getAnnotations() {
        return AnnotationBinding.NoAnnotations;
    }

    @Override
    public IJavaElement getJavaElement() {
        return null;
    }

    @Override
    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Recovered#");
        if (this.variableDeclaration != null) {
            buffer.append("variableDeclaration").append(this.variableDeclaration.getClass()).append(this.variableDeclaration.getName().getIdentifier()).append(this.variableDeclaration.getExtraDimensions());
        }
        return String.valueOf(buffer);
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isEqualTo(IBinding binding) {
        if (binding.isRecovered() && binding.getKind() == 3) {
            return this.getKey().equals(binding.getKey());
        }
        return false;
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isEffectivelyFinal() {
        return false;
    }
}

