/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private static ReferenceQueue queue;
    private static HashMap items;
    private HashMap rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;
    static Thread cleanup;

    public TileMap(TileGenerator source, LRUCache cache) {
        this.cache = cache;
        this.source = source;
    }

    public void setTile(int x, int y, Raster ras) {
        TileMapLRUMember item;
        Point pt = new Point(x, y);
        if (ras == null) {
            Object o = this.rasters.remove(pt);
            if (o != null) {
                this.cache.remove((TileMapLRUMember)o);
            }
            return;
        }
        Object o = this.rasters.get(pt);
        if (o == null) {
            item = new TileMapLRUMember(this, pt, ras);
            this.rasters.put(pt, item);
        } else {
            item = (TileMapLRUMember)o;
            item.setRaster(ras);
        }
        this.cache.add(item);
    }

    public Raster getTileNoCompute(int x, int y) {
        Point pt = new Point(x, y);
        Object o = this.rasters.get(pt);
        if (o == null) {
            return null;
        }
        TileMapLRUMember item = (TileMapLRUMember)o;
        Raster ret = item.retrieveRaster();
        if (ret != null) {
            this.cache.add(item);
        }
        return ret;
    }

    public Raster getTile(int x, int y) {
        Raster ras = null;
        Point pt = new Point(x, y);
        Object o = this.rasters.get(pt);
        TileMapLRUMember item = null;
        if (o != null) {
            item = (TileMapLRUMember)o;
            ras = item.retrieveRaster();
        }
        if (ras == null) {
            ras = this.source.genTile(x, y);
            if (Thread.currentThread().isInterrupted()) {
                return ras;
            }
            if (item != null) {
                item.setRaster(ras);
            } else {
                item = new TileMapLRUMember(this, pt, ras);
                this.rasters.put(pt, item);
            }
        }
        this.cache.add(item);
        return ras;
    }

    static {
        DEBUG = false;
        COUNT = false;
        queue = new ReferenceQueue();
        items = new HashMap();
        cleanup = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Reference ref;
                    try {
                        ref = queue.remove();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    HashMap hashMap = items;
                    synchronized (hashMap) {
                        Object o = items.remove(ref);
                        if (o == null) {
                            continue;
                        }
                        TileMapLRUMember item = (TileMapLRUMember)o;
                        TileMap parent = (TileMap)item.parent.get();
                        if (parent != null) {
                            parent.rasters.remove(item.pt);
                        }
                    }
                }
            }
        };
        cleanup.setDaemon(true);
        cleanup.start();
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference parent;

        TileMapLRUMember(TileMap parent, Point pt, Raster ras) {
            super(ras);
            this.parent = new SoftReference<TileMap>(parent);
            this.pt = pt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRaster(Raster ras) {
            this.hRaster = ras;
            HashMap hashMap = items;
            synchronized (hashMap) {
                if (this.wRaster != null) {
                    items.remove(this.wRaster);
                }
                this.wRaster = new SoftReference<Raster>(ras, queue);
                items.put(this.wRaster, this);
            }
        }
    }
}

