/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Color;
import org.apache.batik.ext.awt.image.AbstractLight;

public class SpotLight
extends AbstractLight {
    private double lightX;
    private double lightY;
    private double lightZ;
    private double pointAtX;
    private double pointAtY;
    private double pointAtZ;
    private double specularExponent;
    private double limitingConeAngle;
    private double limitingCos;
    private final double[] S = new double[3];

    public double getLightX() {
        return this.lightX;
    }

    public double getLightY() {
        return this.lightY;
    }

    public double getLightZ() {
        return this.lightZ;
    }

    public double getPointAtX() {
        return this.pointAtX;
    }

    public double getPointAtY() {
        return this.pointAtY;
    }

    public double getPointAtZ() {
        return this.pointAtZ;
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public double getLimitingConeAngle() {
        return this.limitingConeAngle;
    }

    public SpotLight(double lightX, double lightY, double lightZ, double pointAtX, double pointAtY, double pointAtZ, double specularExponent, double limitingConeAngle, Color lightColor) {
        super(lightColor);
        this.lightX = lightX;
        this.lightY = lightY;
        this.lightZ = lightZ;
        this.pointAtX = pointAtX;
        this.pointAtY = pointAtY;
        this.pointAtZ = pointAtZ;
        this.specularExponent = specularExponent;
        this.limitingConeAngle = limitingConeAngle;
        this.limitingCos = Math.cos(limitingConeAngle * Math.PI / 180.0);
        this.S[0] = pointAtX - lightX;
        this.S[1] = pointAtY - lightY;
        this.S[2] = pointAtZ - lightZ;
        double norm = Math.sqrt(this.S[0] * this.S[0] + this.S[1] * this.S[1] + this.S[2] * this.S[2]);
        this.S[0] = this.S[0] / norm;
        this.S[1] = this.S[1] / norm;
        this.S[2] = this.S[2] / norm;
    }

    public boolean isConstant() {
        return false;
    }

    public final void getLight(double x, double y, double z, double[] L) {
        L[0] = this.lightX - x;
        L[1] = this.lightY - y;
        L[2] = this.lightZ - z;
        double norm = Math.sqrt(L[0] * L[0] + L[1] * L[1] + L[2] * L[2]);
        L[0] = L[0] / norm;
        L[1] = L[1] / norm;
        L[2] = L[2] / norm;
        double LS = -(L[0] * this.S[0] + L[1] * this.S[1] + L[2] * this.S[2]);
        if (LS > this.limitingCos) {
            double Iatt = this.limitingCos / LS;
            Iatt *= Iatt;
            Iatt *= Iatt;
            Iatt *= Iatt;
            Iatt *= Iatt;
            Iatt *= Iatt;
            Iatt *= Iatt;
            Iatt = 1.0 - Iatt;
            LS = Iatt * Math.pow(LS, this.specularExponent);
            L[0] = L[0] * LS;
            L[1] = L[1] * LS;
            L[2] = L[2] * LS;
        } else {
            L[0] = 0.0;
            L[1] = 0.0;
            L[2] = 0.0;
        }
    }
}

