/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.w3c.dom.Element;

public class DocumentDescriptor {
    protected static final int INITIAL_CAPACITY = 101;
    protected Entry[] table = new Entry[101];
    protected int count;

    public int getNumberOfElements() {
        return this.count;
    }

    public int getLocationLine(Element elt) {
        int hash = elt.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.element.equals(elt)) {
                return e.locationLine;
            }
            e = e.next;
        }
        return 0;
    }

    public void setLocationLine(Element elt, int line) {
        Entry e;
        int hash = elt.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.element.equals(elt)) {
                e2.locationLine = line;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len * 3 >>> 2) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = e = new Entry(hash, elt, line, this.table[index]);
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        int i = oldTable.length - 1;
        while (i >= 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = e.hash % this.table.length;
                e.next = this.table[index];
                this.table[index] = e;
            }
            --i;
        }
    }

    static {
        INITIAL_CAPACITY = 101;
    }

    protected static class Entry {
        public int hash;
        public Element element;
        public int locationLine;
        public Entry next;

        public Entry(int hash, Element element, int locationLine, Entry next) {
            this.hash = hash;
            this.element = element;
            this.locationLine = locationLine;
            this.next = next;
        }
    }
}

