/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.events.DOMEvent;
import org.apache.batik.dom.events.DOMKeyEvent;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.events.DOMUIEvent;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.Event;

public class DocumentEventSupport {
    public static final String EVENT_TYPE = "Events";
    public static final String MUTATION_EVENT_TYPE = "MutationEvents";
    public static final String MOUSE_EVENT_TYPE = "MouseEvents";
    public static final String UI_EVENT_TYPE = "UIEvents";
    public static final String KEY_EVENT_TYPE = "KeyEvents";
    protected HashTable eventFactories = new HashTable();

    public DocumentEventSupport() {
        this.eventFactories.put(EVENT_TYPE.toLowerCase(), new SimpleEventFactory());
        this.eventFactories.put(MUTATION_EVENT_TYPE.toLowerCase(), new MutationEventFactory());
        this.eventFactories.put(MOUSE_EVENT_TYPE.toLowerCase(), new MouseEventFactory());
        this.eventFactories.put(KEY_EVENT_TYPE.toLowerCase(), new KeyEventFactory());
        this.eventFactories.put(UI_EVENT_TYPE.toLowerCase(), new UIEventFactory());
    }

    public Event createEvent(String eventType) throws DOMException {
        EventFactory ef = (EventFactory)this.eventFactories.get(eventType.toLowerCase());
        if (ef == null) {
            throw new DOMException(9, "Bad event type: " + eventType);
        }
        return ef.createEvent();
    }

    public void registerEventFactory(String eventType, EventFactory factory) {
        this.eventFactories.put(eventType.toLowerCase(), factory);
    }

    static {
        EVENT_TYPE = EVENT_TYPE;
        MUTATION_EVENT_TYPE = MUTATION_EVENT_TYPE;
        MOUSE_EVENT_TYPE = MOUSE_EVENT_TYPE;
        UI_EVENT_TYPE = UI_EVENT_TYPE;
        KEY_EVENT_TYPE = KEY_EVENT_TYPE;
    }

    protected static class UIEventFactory
    implements EventFactory {
        protected UIEventFactory() {
        }

        public Event createEvent() {
            return new DOMUIEvent();
        }
    }

    protected static class KeyEventFactory
    implements EventFactory {
        protected KeyEventFactory() {
        }

        public Event createEvent() {
            return new DOMKeyEvent();
        }
    }

    protected static class MouseEventFactory
    implements EventFactory {
        protected MouseEventFactory() {
        }

        public Event createEvent() {
            return new DOMMouseEvent();
        }
    }

    protected static class MutationEventFactory
    implements EventFactory {
        protected MutationEventFactory() {
        }

        public Event createEvent() {
            return new DOMMutationEvent();
        }
    }

    protected static class SimpleEventFactory
    implements EventFactory {
        protected SimpleEventFactory() {
        }

        public Event createEvent() {
            return new DOMEvent();
        }
    }

    public static interface EventFactory {
        public Event createEvent();
    }
}

