/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public abstract class AbstractNode
implements ExtendedNode,
Serializable {
    protected static final NodeList EMPTY_NODE_LIST = new NodeList(){

        public Node item(int i) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    };
    protected AbstractDocument ownerDocument;
    protected transient EventSupport eventSupport;

    public void setNodeName(String v) {
    }

    public void setOwnerDocument(Document doc) {
        this.ownerDocument = (AbstractDocument)doc;
    }

    public void setSpecified(boolean v) {
        throw this.createDOMException((short)11, "node.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public Node getParentNode() {
        return null;
    }

    public void setParentNode(Node v) {
        throw this.createDOMException((short)3, "parent.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public NodeList getChildNodes() {
        return EMPTY_NODE_LIST;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public void setPreviousSibling(Node n) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node getPreviousSibling() {
        return null;
    }

    public void setNextSibling(Node n) {
        throw this.createDOMException((short)3, "sibling.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node getNextSibling() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node cloneNode(boolean deep) {
        return deep ? this.deepCopyInto(this.newNode()) : this.copyInto(this.newNode());
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return this.getCurrentDocument().getImplementation().hasFeature(feature, version);
    }

    public String getPrefix() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getPrefix(this.getNodeName());
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String uri = this.getNamespaceURI();
        if (uri == null) {
            throw this.createDOMException((short)14, "namespace", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String name = this.getLocalName();
        if (prefix == null) {
            this.setNodeName(name);
        }
        if (!prefix.equals("") && !DOMUtilities.isValidName(prefix)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), prefix});
        }
        if (!DOMUtilities.isValidPrefix(prefix)) {
            throw this.createDOMException((short)14, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), prefix});
        }
        if (prefix.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(uri) || prefix.equals("xmlns") && !"http://www.w3.org/2000/xmlns/".equals(uri)) {
            throw this.createDOMException((short)14, "namespace.uri", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), uri});
        }
        this.setNodeName(prefix + ":" + name);
    }

    public String getLocalName() {
        return this.getNamespaceURI() == null ? null : DOMUtilities.getLocalName(this.getNodeName());
    }

    public DOMException createDOMException(short type, String key, Object[] args) {
        try {
            return new DOMException(type, this.getCurrentDocument().formatMessage(key, args));
        }
        catch (Exception e) {
            return new DOMException(type, key);
        }
    }

    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport();
            AbstractDocument doc = this.getCurrentDocument();
            doc.setEventsEnabled(true);
        }
        this.eventSupport.addEventListener(type, listener, useCapture);
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        if (this.eventSupport != null) {
            this.eventSupport.removeEventListener(type, listener, useCapture);
        }
    }

    public NodeEventTarget getParentNodeEventTarget() {
        return (NodeEventTarget)((Object)this.getParentNode());
    }

    public boolean dispatchEvent(Event evt) throws EventException {
        return EventSupport.dispatchEvent(this, evt);
    }

    public EventSupport getEventSupport() {
        return this.eventSupport;
    }

    public void fireDOMNodeInsertedIntoDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMNodeInsertedIntoDocument", true, false, null, null, null, null, (short)2);
            this.dispatchEvent(ev);
        }
    }

    public void fireDOMNodeRemovedFromDocumentEvent() {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMNodeRemovedFromDocument", true, false, null, null, null, null, (short)3);
            this.dispatchEvent(ev);
        }
    }

    protected void fireDOMCharacterDataModifiedEvent(String oldv, String newv) {
        AbstractDocument doc = this.getCurrentDocument();
        if (doc.getEventsEnabled()) {
            AbstractDocument de = doc;
            MutationEvent ev = (MutationEvent)de.createEvent("MutationEvents");
            ev.initMutationEvent("DOMCharacterDataModified", true, false, null, oldv, newv, null, (short)1);
            this.dispatchEvent(ev);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this.ownerDocument;
    }

    protected abstract Node newNode();

    protected Node export(Node n, AbstractDocument d) {
        AbstractNode p = (AbstractNode)n;
        p.ownerDocument = d;
        p.setReadonly(false);
        return n;
    }

    protected Node deepExport(Node n, AbstractDocument d) {
        AbstractNode p = (AbstractNode)n;
        p.ownerDocument = d;
        p.setReadonly(false);
        return n;
    }

    protected Node copyInto(Node n) {
        AbstractNode an = (AbstractNode)n;
        an.ownerDocument = this.ownerDocument;
        return n;
    }

    protected Node deepCopyInto(Node n) {
        AbstractNode an = (AbstractNode)n;
        an.ownerDocument = this.ownerDocument;
        return n;
    }

    protected void checkChildType(Node n, boolean replace) {
        throw this.createDOMException((short)3, "children.not.allowed", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
    }
}

