/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
		TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	public final static int
    TokenNameIdentifier = 15,
    TokenNameabstract = 47,
    TokenNameassert = 78,
    TokenNameboolean = 112,
    TokenNamebreak = 79,
    TokenNamebyte = 113,
    TokenNamecase = 91,
    TokenNamecatch = 92,
    TokenNamechar = 114,
    TokenNameclass = 71,
    TokenNamecontinue = 80,
    TokenNameconst = 133,
    TokenNamedefault = 97,
    TokenNamedo = 81,
    TokenNamedouble = 115,
    TokenNameelse = 96,
    TokenNameenum = 82,
    TokenNameextends = 90,
    TokenNamefalse = 56,
    TokenNamefinal = 48,
    TokenNamefinally = 95,
    TokenNamefloat = 116,
    TokenNamefor = 83,
    TokenNamegoto = 134,
    TokenNameif = 84,
    TokenNameimplements = 100,
    TokenNameimport = 93,
    TokenNameinstanceof = 16,
    TokenNameint = 117,
    TokenNameopens = 122,
    TokenNameinterface = 75,
    TokenNamelong = 118,
    TokenNamenative = 49,
    TokenNamenew = 42,
    TokenNamenull = 57,
    TokenNamepackage = 89,
    TokenNameprivate = 50,
    TokenNameprotected = 51,
    TokenNamepublic = 52,
    TokenNamereturn = 85,
    TokenNameshort = 119,
    TokenNamestatic = 45,
    TokenNamestrictfp = 53,
    TokenNamesuper = 43,
    TokenNameswitch = 86,
    TokenNamesynchronized = 46,
    TokenNamethis = 44,
    TokenNamethrow = 87,
    TokenNamethrows = 98,
    TokenNametransient = 54,
    TokenNametrue = 58,
    TokenNametry = 88,
    TokenNamevoid = 120,
    TokenNamevolatile = 55,
    TokenNamewhile = 77,
    TokenNamemodule = 123,
    TokenNameopen = 124,
    TokenNamerequires = 125,
    TokenNametransitive = 129,
    TokenNameexports = 126,
    TokenNameto = 130,
    TokenNameuses = 127,
    TokenNameprovides = 128,
    TokenNamewith = 131,
    TokenNameaspect = 27,
    TokenNamepointcut = 29,
    TokenNamearound = 34,
    TokenNamebefore = 31,
    TokenNameafter = 32,
    TokenNamedeclare = 33,
    TokenNameprivileged = 28,
    TokenNameIntegerLiteral = 59,
    TokenNameLongLiteral = 60,
    TokenNameFloatingPointLiteral = 61,
    TokenNameDoubleLiteral = 62,
    TokenNameCharacterLiteral = 63,
    TokenNameStringLiteral = 64,
    TokenNamePLUS_PLUS = 3,
    TokenNameMINUS_MINUS = 4,
    TokenNameEQUAL_EQUAL = 23,
    TokenNameLESS_EQUAL = 17,
    TokenNameGREATER_EQUAL = 18,
    TokenNameNOT_EQUAL = 20,
    TokenNameLEFT_SHIFT = 21,
    TokenNameRIGHT_SHIFT = 12,
    TokenNameUNSIGNED_RIGHT_SHIFT = 14,
    TokenNamePLUS_EQUAL = 101,
    TokenNameMINUS_EQUAL = 102,
    TokenNameMULTIPLY_EQUAL = 103,
    TokenNameDIVIDE_EQUAL = 104,
    TokenNameAND_EQUAL = 105,
    TokenNameOR_EQUAL = 106,
    TokenNameXOR_EQUAL = 107,
    TokenNameREMAINDER_EQUAL = 108,
    TokenNameLEFT_SHIFT_EQUAL = 109,
    TokenNameRIGHT_SHIFT_EQUAL = 110,
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 111,
    TokenNameOR_OR = 38,
    TokenNameAND_AND = 37,
    TokenNamePLUS = 2,
    TokenNameMINUS = 6,
    TokenNameNOT = 68,
    TokenNameREMAINDER = 10,
    TokenNameXOR = 30,
    TokenNameAND = 22,
    TokenNameMULTIPLY = 8,
    TokenNameOR = 36,
    TokenNameTWIDDLE = 72,
    TokenNameDIVIDE = 11,
    TokenNameGREATER = 13,
    TokenNameLESS = 7,
    TokenNameLPAREN = 19,
    TokenNameRPAREN = 25,
    TokenNameLBRACE = 65,
    TokenNameRBRACE = 40,
    TokenNameLBRACKET = 5,
    TokenNameRBRACKET = 69,
    TokenNameSEMICOLON = 26,
    TokenNameQUESTION = 35,
    TokenNameCOLON = 66,
    TokenNameCOMMA = 39,
    TokenNameDOT = 1,
    TokenNameEQUAL = 74,
    TokenNameAT = 41,
    TokenNameELLIPSIS = 99,
    TokenNameARROW = 121,
    TokenNameCOLON_COLON = 9,
    TokenNameBeginLambda = 67,
    TokenNameBeginIntersectionCast = 73,
    TokenNameBeginTypeArguments = 94,
    TokenNameElidedSemicolonAndRightBrace = 76,
    TokenNameAT308 = 24,
    TokenNameAT308DOTDOTDOT = 132,
    TokenNameEOF = 70,
    TokenNameERROR = 135;
}
