/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Axis;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;

final class AxisExpression
extends NodeSetExpression {
    private byte axis;
    private NodeTest test;
    private NodeInfo contextNode = null;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
    }

    public Expression simplify() {
        return this;
    }

    public int getDependencies() {
        if (this.contextNode == null) {
            return 8;
        }
        return 0;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & 8) != 0) {
            AxisExpression axisExpression = new AxisExpression(this.axis, this.test);
            axisExpression.contextNode = context.getContextNodeInfo();
            return axisExpression;
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        NodeInfo nodeInfo = this.contextNode == null ? context.getContextNodeInfo() : this.contextNode;
        AxisEnumeration axisEnumeration = nodeInfo.getEnumeration(this.axis, this.test);
        if (bl && !axisEnumeration.isSorted()) {
            NodeSetExtent nodeSetExtent = new NodeSetExtent(axisEnumeration, (NodeOrderComparer)LocalOrderComparer.getInstance());
            nodeSetExtent.sort();
            return nodeSetExtent.enumerate();
        }
        return axisEnumeration;
    }

    public Value evaluate(Context context) throws XPathException {
        NodeSetIntent nodeSetIntent = new NodeSetIntent((NodeSetExpression)this.reduce(8, context), context.getController());
        nodeSetIntent.setSorted(Axis.isForwards[this.axis]);
        return nodeSetIntent;
    }
}

