/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.GeneralOutputter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(TransformerFactoryImpl transformerFactoryImpl) {
        super(transformerFactoryImpl);
    }

    public void transform(Source source, Result result) throws TransformerException {
        SAXSource sAXSource = this.getTransformerFactory().getSAXSource(source, false);
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (result instanceof SAXResult) {
            ContentHandler contentHandler = ((SAXResult)result).getHandler();
            xMLReader.setContentHandler(contentHandler);
            try {
                xMLReader.parse(sAXSource.getInputSource());
            }
            catch (Exception exception) {
                throw new TransformerException(exception);
            }
        }
        NamePool namePool = this.getNamePool();
        Properties properties = this.getOutputProperties();
        GeneralOutputter generalOutputter = new GeneralOutputter(namePool);
        generalOutputter.setOutputDestination(properties, result);
        Emitter emitter = generalOutputter.getEmitter();
        ContentEmitter contentEmitter = new ContentEmitter();
        contentEmitter.setNamePool(namePool);
        contentEmitter.setEmitter(emitter);
        try {
            xMLReader.setContentHandler(contentEmitter);
            xMLReader.parse(sAXSource.getInputSource());
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
        generalOutputter.close();
    }
}

