/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SafeFileTable;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SavedState
implements ISavedState {
    ElementTree oldTree;
    ElementTree newTree;
    SafeFileTable fileTable;
    String pluginId;
    Workspace workspace;

    SavedState(Workspace workspace, String pluginId, ElementTree oldTree, ElementTree newTree) throws CoreException {
        this.workspace = workspace;
        this.pluginId = pluginId;
        this.newTree = newTree;
        this.oldTree = oldTree;
        this.fileTable = this.restoreFileTable();
    }

    void forgetTrees() {
        this.newTree = null;
        this.oldTree = null;
    }

    public int getSaveNumber() {
        return this.workspace.getSaveManager().getSaveNumber(this.pluginId);
    }

    protected SafeFileTable getFileTable() {
        return this.fileTable;
    }

    protected SafeFileTable restoreFileTable() throws CoreException {
        if (this.fileTable == null) {
            this.fileTable = new SafeFileTable(this.pluginId);
        }
        return this.fileTable;
    }

    public IPath lookup(IPath file) {
        return this.getFileTable().lookup(file);
    }

    public IPath[] getFiles() {
        return this.getFileTable().getFiles();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processResourceChangeEvents(IResourceChangeListener listener) {
        try {
            IWorkspaceRoot rule;
            block7: {
                block6: {
                    rule = this.workspace.getRoot();
                    try {
                        block9: {
                            block8: {
                                this.workspace.prepareOperation(rule, null);
                                if (this.oldTree == null) break block8;
                                if (this.newTree != null) break block9;
                            }
                            Object var4_4 = null;
                            break block6;
                        }
                        this.workspace.beginOperation(true);
                        ResourceDelta delta = ResourceDeltaFactory.computeDelta(this.workspace, this.oldTree, this.newTree, Path.ROOT, -1L);
                        this.forgetTrees();
                        this.workspace.getNotificationManager().broadcastChanges(listener, 16, delta);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.workspace.endOperation(rule, false, null);
                        throw throwable;
                    }
                }
                this.workspace.endOperation(rule, false, null);
                return;
            }
            Object var4_6 = null;
            this.workspace.endOperation(rule, false, null);
            return;
        }
        catch (CoreException e) {
            ResourceStatus status = new ResourceStatus(2, null, e.getMessage(), e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }
}

