/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class ResolvedMember
extends Member
implements IHasPosition,
AnnotatedElement {
    public String[] parameterNames = null;
    protected TypeX[] checkedExceptions = TypeX.NONE;
    private Set annotationTypes = null;
    private boolean isAnnotatedElsewhere = false;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext = null;
    public static final ResolvedMember[] NONE = new ResolvedMember[0];

    public ResolvedMember(Member.Kind kind, TypeX declaringType, int modifiers, TypeX returnType, String name, TypeX[] parameterTypes) {
        super(kind, declaringType, modifiers, returnType, name, parameterTypes);
    }

    public ResolvedMember(Member.Kind kind, TypeX declaringType, int modifiers, TypeX returnType, String name, TypeX[] parameterTypes, TypeX[] checkedExceptions) {
        super(kind, declaringType, modifiers, returnType, name, parameterTypes);
        this.checkedExceptions = checkedExceptions;
    }

    public ResolvedMember(Member.Kind kind, TypeX declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public final int getModifiers(World world) {
        return this.modifiers;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final TypeX[] getExceptions(World world) {
        return this.getExceptions();
    }

    public TypeX[] getExceptions() {
        return this.checkedExceptions;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return null;
    }

    public boolean isAjSynthetic() {
        return true;
    }

    public boolean hasAnnotations() {
        return this.annotationTypes == null;
    }

    public boolean hasAnnotation(TypeX ofType) {
        if (this.annotationTypes == null) {
            return false;
        }
        return this.annotationTypes.contains(ofType);
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        if (this.annotationTypes == null) {
            return null;
        }
        return this.annotationTypes.toArray(new ResolvedTypeX[0]);
    }

    public void setAnnotationTypes(TypeX[] annotationtypes) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet();
        }
        for (int i = 0; i < annotationtypes.length; ++i) {
            TypeX typeX = annotationtypes[i];
            this.annotationTypes.add(typeX);
        }
    }

    public void addAnnotation(AnnotationX annotation) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new HashSet();
        }
        this.annotationTypes.add(annotation.getSignature());
    }

    public boolean isBridgeMethod() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarargsMethod() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isSynthetic() {
        return false;
    }

    public void write(DataOutputStream s) throws IOException {
        this.getKind().write(s);
        this.getDeclaringType().write(s);
        s.writeInt(this.modifiers);
        s.writeUTF(this.getName());
        s.writeUTF(this.getSignature());
        TypeX.writeArray(this.getExceptions(), s);
        s.writeInt(this.getStart());
        s.writeInt(this.getEnd());
    }

    public static void writeArray(ResolvedMember[] members, DataOutputStream s) throws IOException {
        s.writeInt(members.length);
        int len = members.length;
        for (int i = 0; i < len; ++i) {
            members[i].write(s);
        }
    }

    public static ResolvedMember readResolvedMember(DataInputStream s, ISourceContext sourceContext) throws IOException {
        ResolvedMember m = new ResolvedMember(Member.Kind.read(s), TypeX.read(s), s.readInt(), s.readUTF(), s.readUTF());
        m.checkedExceptions = TypeX.readArray(s);
        m.start = s.readInt();
        m.end = s.readInt();
        m.sourceContext = sourceContext;
        return m;
    }

    public static ResolvedMember[] readResolvedMemberArray(DataInputStream s, ISourceContext context) throws IOException {
        int len = s.readInt();
        ResolvedMember[] members = new ResolvedMember[len];
        for (int i = 0; i < len; ++i) {
            members[i] = ResolvedMember.readResolvedMember(s, context);
        }
        return members;
    }

    public ResolvedMember resolve(World world) {
        if (this.annotationTypes != null) {
            HashSet<ResolvedTypeX> r = new HashSet<ResolvedTypeX>();
            Iterator iter = this.annotationTypes.iterator();
            while (iter.hasNext()) {
                TypeX element = (TypeX)iter.next();
                r.add(world.resolve(element));
            }
            this.annotationTypes = r;
        }
        return this;
    }

    public ISourceContext getSourceContext(World world) {
        return this.getDeclaringType().resolve(world).getSourceContext();
    }

    public final String[] getParameterNames() {
        return this.parameterNames;
    }

    public final String[] getParameterNames(World world) {
        return this.getParameterNames();
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return null;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceContext == null) {
            return null;
        }
        return this.sourceContext.makeSourceLocation(this);
    }

    public int getEnd() {
        return this.end;
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public int getStart() {
        return this.start;
    }

    public void setPosition(int sourceStart, int sourceEnd) {
        this.start = sourceStart;
        this.end = sourceEnd;
    }

    public void setSourceContext(ISourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isVisible(ResolvedTypeX fromType) {
        World world = fromType.getWorld();
        return ResolvedTypeX.isVisible(this.getModifiers(), this.getDeclaringType().resolve(world), fromType);
    }

    public void setCheckedExceptions(TypeX[] checkedExceptions) {
        this.checkedExceptions = checkedExceptions;
    }

    public void setAnnotatedElsewhere(boolean b) {
        this.isAnnotatedElsewhere = b;
    }

    public boolean isAnnotatedElsewhere() {
        return this.isAnnotatedElsewhere;
    }
}

