/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.DOMException;

public class AttrNSImpl
extends AttrImpl {
    static final long serialVersionUID = -781906615369795414L;
    static final String xmlnsURI = "http://www.w3.org/2000/xmlns/";
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;

    protected AttrNSImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl, string);
    }

    protected AttrNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2) {
        super(coreDocumentImpl, string2);
        int n = string2.indexOf(58);
        if (n < 0) {
            Object var5_5 = null;
            this.localName = string2;
            if (coreDocumentImpl.errorChecking && string2.equals("xmlns") && (string == null || !string.equals(xmlnsURI))) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        } else {
            String string3 = string2.substring(0, n);
            this.localName = string2.substring(n + 1);
            if (coreDocumentImpl.errorChecking) {
                if (string == null || this.localName.length() == 0 || this.localName.indexOf(58) >= 0) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
                if (string3.equals("xml") ? !string.equals(xmlURI) : (string3.equals("xmlns") ? !string.equals(xmlnsURI) : n == 0)) {
                    throw new DOMException(14, "DOM003 Namespace error");
                }
            }
        }
        this.namespaceURI = string;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int n;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (n = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, n);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (!CoreDocumentImpl.isXMLName(string)) {
                throw new DOMException(5, "DOM002 Illegal character");
            }
            if (this.namespaceURI == null || string.indexOf(58) >= 0) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
            if (string != null && (string.equals("xmlns") ? !this.namespaceURI.equals(xmlnsURI) : (string.equals("xml") ? !this.namespaceURI.equals(xmlURI) : this.name.equals("xmlns")))) {
                throw new DOMException(14, "DOM003 Namespace error");
            }
        }
        this.name = String.valueOf(string) + ":" + this.localName;
    }
}

