/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public abstract class Expression
extends Statement {
    public Constant constant;
    public int implicitConversion;
    public TypeBinding resolvedType;

    public static final boolean isConstantValueRepresentable(Constant constant, int constantTypeID, int targetTypeID) {
        if (targetTypeID == constantTypeID) {
            return true;
        }
        switch (targetTypeID) {
            case 2: {
                switch (constantTypeID) {
                    case 2: {
                        return true;
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.charValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.charValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.charValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.charValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.charValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.charValue();
                    }
                }
                return false;
            }
            case 9: {
                switch (constantTypeID) {
                    case 2: {
                        return (float)constant.charValue() == constant.floatValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.floatValue();
                    }
                    case 9: {
                        return true;
                    }
                    case 10: {
                        return (float)constant.intValue() == constant.floatValue();
                    }
                    case 4: {
                        return (float)constant.shortValue() == constant.floatValue();
                    }
                    case 3: {
                        return (float)constant.byteValue() == constant.floatValue();
                    }
                    case 7: {
                        return (float)constant.longValue() == constant.floatValue();
                    }
                }
                return false;
            }
            case 8: {
                switch (constantTypeID) {
                    case 2: {
                        return (double)constant.charValue() == constant.doubleValue();
                    }
                    case 8: {
                        return true;
                    }
                    case 9: {
                        return (double)constant.floatValue() == constant.doubleValue();
                    }
                    case 10: {
                        return (double)constant.intValue() == constant.doubleValue();
                    }
                    case 4: {
                        return (double)constant.shortValue() == constant.doubleValue();
                    }
                    case 3: {
                        return (double)constant.byteValue() == constant.doubleValue();
                    }
                    case 7: {
                        return (double)constant.longValue() == constant.doubleValue();
                    }
                }
                return false;
            }
            case 3: {
                switch (constantTypeID) {
                    case 2: {
                        return constant.charValue() == constant.byteValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.byteValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.byteValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.byteValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.byteValue();
                    }
                    case 3: {
                        return true;
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.byteValue();
                    }
                }
                return false;
            }
            case 4: {
                switch (constantTypeID) {
                    case 2: {
                        return constant.charValue() == constant.shortValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.shortValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.shortValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.shortValue();
                    }
                    case 4: {
                        return true;
                    }
                    case 3: {
                        return constant.byteValue() == constant.shortValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.shortValue();
                    }
                }
                return false;
            }
            case 10: {
                switch (constantTypeID) {
                    case 2: {
                        return constant.charValue() == constant.intValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.intValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.intValue();
                    }
                    case 10: {
                        return true;
                    }
                    case 4: {
                        return constant.shortValue() == constant.intValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.intValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.intValue();
                    }
                }
                return false;
            }
            case 7: {
                switch (constantTypeID) {
                    case 2: {
                        return (long)constant.charValue() == constant.longValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.longValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.longValue();
                    }
                    case 10: {
                        return (long)constant.intValue() == constant.longValue();
                    }
                    case 4: {
                        return (long)constant.shortValue() == constant.longValue();
                    }
                    case 3: {
                        return (long)constant.byteValue() == constant.longValue();
                    }
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        return this.analyseCode(currentScope, flowContext, flowInfo);
    }

    public final boolean checkCastTypesCompatibility(Scope scope, TypeBinding castType, TypeBinding expressionType, Expression expression) {
        boolean use15specifics;
        if (castType == null || expressionType == null) {
            return true;
        }
        LookupEnvironment env = scope.environment();
        boolean bl = use15specifics = env.options.sourceLevel >= 0x310000L;
        if (castType.isBaseType()) {
            if (expressionType.isBaseType()) {
                if (expressionType == castType) {
                    if (expression != null) {
                        this.constant = expression.constant;
                    }
                    this.tagAsUnnecessaryCast(scope, castType);
                    return true;
                }
                boolean necessary = false;
                if (expressionType.isCompatibleWith(castType) || (necessary = BaseTypeBinding.isNarrowing(castType.id, expressionType.id))) {
                    if (expression != null) {
                        expression.implicitConversion = (castType.id << 4) + expressionType.id;
                        if (expression.constant != Constant.NotAConstant) {
                            this.constant = expression.constant.castTo(expression.implicitConversion);
                        }
                    }
                    if (!necessary) {
                        this.tagAsUnnecessaryCast(scope, castType);
                    }
                    return true;
                }
            } else if (use15specifics && env.computeBoxingType(expressionType) == castType) {
                return true;
            }
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (use15specifics && expressionType.isBaseType() && env.computeBoxingType(castType) == expressionType) {
            return true;
        }
        if (expressionType == BaseTypes.NullBinding) {
            this.tagAsUnnecessaryCast(scope, castType);
            return true;
        }
        if (expressionType.isBaseType()) {
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (expressionType.isArrayType()) {
            if (castType == expressionType) {
                this.tagAsUnnecessaryCast(scope, castType);
                return true;
            }
            if (castType.isArrayType()) {
                TypeBinding exprElementType = ((ArrayBinding)expressionType).elementsType();
                if (exprElementType.isBaseType()) {
                    if (((ArrayBinding)castType).elementsType() == exprElementType) {
                        this.tagAsNeedCheckCast();
                        return true;
                    }
                    this.reportIllegalCast(scope, castType, expressionType);
                    return false;
                }
                return this.checkCastTypesCompatibility(scope, ((ArrayBinding)castType).elementsType(), exprElementType, expression);
            }
            if (castType.isTypeVariable()) {
                ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType);
                if (match == null) {
                    this.checkUnsafeCast(scope, castType, expressionType, match, true);
                }
                return this.checkCastTypesCompatibility(scope, castType.erasure(), expressionType, expression);
            }
            if (castType.isClass()) {
                if (castType.id == 1) {
                    this.tagAsUnnecessaryCast(scope, castType);
                    return true;
                }
            } else if (castType.id == 36 || castType.id == 37) {
                this.tagAsNeedCheckCast();
                return true;
            }
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (expressionType.isTypeVariable() || expressionType.isWildcard()) {
            ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType);
            if (match != null) {
                this.tagAsUnnecessaryCast(scope, castType);
                return true;
            }
            return this.checkCastTypesCompatibility(scope, castType, expressionType.erasure(), expression);
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType()) {
                if (expressionType.id == 1) {
                    this.tagAsNeedCheckCast();
                    return true;
                }
            } else {
                if (castType.isTypeVariable()) {
                    ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType);
                    if (match == null) {
                        this.checkUnsafeCast(scope, castType, expressionType, match, true);
                    }
                    return this.checkCastTypesCompatibility(scope, castType.erasure(), expressionType, expression);
                }
                if (castType.isClass()) {
                    ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType.erasure());
                    if (match != null) {
                        if (expression != null && castType.id == 11) {
                            this.constant = expression.constant;
                        }
                        return this.checkUnsafeCast(scope, castType, expressionType, match, false);
                    }
                    match = ((ReferenceBinding)castType).findSuperTypeErasingTo((ReferenceBinding)expressionType.erasure());
                    if (match != null) {
                        this.tagAsNeedCheckCast();
                        return this.checkUnsafeCast(scope, castType, expressionType, match, true);
                    }
                } else {
                    ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType.erasure());
                    if (match != null) {
                        return this.checkUnsafeCast(scope, castType, expressionType, match, false);
                    }
                    if (!((ReferenceBinding)expressionType).isFinal()) {
                        this.tagAsNeedCheckCast();
                        match = ((ReferenceBinding)castType).findSuperTypeErasingTo((ReferenceBinding)expressionType.erasure());
                        if (match != null) {
                            return this.checkUnsafeCast(scope, castType, expressionType, match, true);
                        }
                        return true;
                    }
                }
            }
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (castType.isArrayType()) {
            if (expressionType.id == 36 || expressionType.id == 37) {
                this.tagAsNeedCheckCast();
                return true;
            }
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (castType.isTypeVariable()) {
            ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType);
            if (match == null) {
                this.checkUnsafeCast(scope, castType, expressionType, match, true);
            }
            return this.checkCastTypesCompatibility(scope, castType.erasure(), expressionType, expression);
        }
        if (castType.isClass()) {
            ReferenceBinding match;
            if (castType.id == 1) {
                this.tagAsUnnecessaryCast(scope, castType);
                return true;
            }
            if (((ReferenceBinding)castType).isFinal() && (match = ((ReferenceBinding)castType).findSuperTypeErasingTo((ReferenceBinding)expressionType.erasure())) == null) {
                this.reportIllegalCast(scope, castType, expressionType);
                return false;
            }
        } else {
            ReferenceBinding match = ((ReferenceBinding)expressionType).findSuperTypeErasingTo((ReferenceBinding)castType.erasure());
            if (match != null) {
                return this.checkUnsafeCast(scope, castType, expressionType, match, false);
            }
            match = ((ReferenceBinding)castType).findSuperTypeErasingTo((ReferenceBinding)expressionType.erasure());
            if (match != null) {
                this.tagAsNeedCheckCast();
                return this.checkUnsafeCast(scope, castType, expressionType, match, true);
            }
            MethodBinding[] castTypeMethods = this.getAllInheritedMethods((ReferenceBinding)castType);
            MethodBinding[] expressionTypeMethods = this.getAllInheritedMethods((ReferenceBinding)expressionType);
            int exprMethodsLength = expressionTypeMethods.length;
            int i = 0;
            int castMethodsLength = castTypeMethods.length;
            while (i < castMethodsLength) {
                int j = 0;
                while (j < exprMethodsLength) {
                    if (castTypeMethods[i].returnType != expressionTypeMethods[j].returnType && CharOperation.equals(castTypeMethods[i].selector, expressionTypeMethods[j].selector) && castTypeMethods[i].areParametersEqual(expressionTypeMethods[j])) {
                        this.reportIllegalCast(scope, castType, expressionType);
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.tagAsNeedCheckCast();
        return true;
    }

    public FlowInfo checkNullStatus(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, int nullStatus) {
        LocalVariableBinding local = this.localVariableBinding();
        if (local != null) {
            switch (nullStatus) {
                case 1: {
                    flowContext.recordUsingNullReference(scope, local, this, 1, flowInfo);
                    flowInfo.markAsDefinitelyNull(local);
                    break;
                }
                case -1: {
                    flowContext.recordUsingNullReference(scope, local, this, -1, flowInfo);
                    flowInfo.markAsDefinitelyNonNull(local);
                    break;
                }
            }
        }
        return flowInfo;
    }

    private MethodBinding[] getAllInheritedMethods(ReferenceBinding binding) {
        ArrayList collector = new ArrayList();
        this.getAllInheritedMethods0(binding, collector);
        return collector.toArray(new MethodBinding[collector.size()]);
    }

    private void getAllInheritedMethods0(ReferenceBinding binding, ArrayList collector) {
        if (!binding.isInterface()) {
            return;
        }
        MethodBinding[] methodBindings = binding.methods();
        int i = 0;
        int max = methodBindings.length;
        while (i < max) {
            collector.add(methodBindings[i]);
            ++i;
        }
        ReferenceBinding[] superInterfaces = binding.superInterfaces();
        int i2 = 0;
        int max2 = superInterfaces.length;
        while (i2 < max2) {
            this.getAllInheritedMethods0(superInterfaces[i2], collector);
            ++i2;
        }
    }

    public void checkNullComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse) {
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (match == castType) {
            if (!isNarrowing) {
                this.tagAsUnnecessaryCast(scope, castType);
            }
            return true;
        }
        if ((castType.isBoundParameterizedType() || castType.isGenericType()) && match.isProvablyDistinctFrom(isNarrowing ? expressionType : castType, 0)) {
            this.reportIllegalCast(scope, castType, expressionType);
            return false;
        }
        if (!isNarrowing) {
            this.tagAsUnnecessaryCast(scope, castType);
        }
        return true;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        if (this.implicitConversion != 0) {
            return;
        }
        if (runtimeTimeType != BaseTypes.NullBinding && runtimeTimeType.isBaseType()) {
            if (!compileTimeType.isBaseType()) {
                TypeBinding unboxedType = scope.environment().computeBoxingType(compileTimeType);
                this.implicitConversion = 1024;
                scope.problemReporter().autoboxing(this, compileTimeType, runtimeTimeType);
                compileTimeType = unboxedType;
            }
        } else if (compileTimeType != BaseTypes.NullBinding && compileTimeType.isBaseType()) {
            TypeBinding boxedType = scope.environment().computeBoxingType(runtimeTimeType);
            if (boxedType == runtimeTimeType) {
                boxedType = compileTimeType;
            }
            this.implicitConversion = 0x200 | (boxedType.id << 4) + compileTimeType.id;
            scope.problemReporter().autoboxing(this, compileTimeType, runtimeTimeType);
            return;
        }
        switch (runtimeTimeType.id) {
            case 2: 
            case 3: 
            case 4: {
                this.implicitConversion |= 160 + compileTimeType.id;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.implicitConversion |= (runtimeTimeType.id << 4) + compileTimeType.id;
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.generateCode(currentScope, codeStream, false);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.constant == ASTNode.NotAConstant) {
            throw new ShouldNotImplement(Util.bind("ast.missingCode"));
        }
        int pc = codeStream.position;
        codeStream.generateConstant(this.constant, this.implicitConversion);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            int pc = codeStream.position;
            if (this.constant.booleanValue()) {
                if (valueRequired && falseLabel == null && trueLabel != null) {
                    codeStream.goto_(trueLabel);
                }
            } else if (valueRequired && falseLabel != null && trueLabel == null) {
                codeStream.goto_(falseLabel);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        this.generateCode(currentScope, codeStream, valueRequired);
        int position = codeStream.position;
        if (valueRequired) {
            if (falseLabel == null) {
                if (trueLabel != null) {
                    codeStream.ifne(trueLabel);
                }
            } else if (trueLabel == null) {
                codeStream.ifeq(falseLabel);
            }
        }
        codeStream.updateLastRecordedEndPC(position);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int typeID) {
        if (typeID == 11 && this.constant != ASTNode.NotAConstant && this.constant.stringValue().length() == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, true);
        codeStream.invokeStringConcatenationAppendForType(typeID);
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int typeID) {
        codeStream.newStringContatenation();
        codeStream.dup();
        switch (typeID) {
            case 0: 
            case 1: {
                codeStream.invokeStringConcatenationDefaultConstructor();
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringConcatenationAppendForType(1);
                return;
            }
            case 11: 
            case 12: {
                if (this.constant != ASTNode.NotAConstant) {
                    String stringValue = this.constant.stringValue();
                    if (stringValue.length() == 0) {
                        codeStream.invokeStringConcatenationDefaultConstructor();
                        return;
                    }
                    codeStream.ldc(stringValue);
                    break;
                }
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(1);
                break;
            }
            default: {
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(typeID);
            }
        }
        codeStream.invokeStringConcatenationStringConstructor();
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public boolean isConstantValueOfTypeAssignableToType(TypeBinding constantType, TypeBinding targetType) {
        if (this.constant == Constant.NotAConstant) {
            return false;
        }
        if (constantType == targetType) {
            return true;
        }
        if (constantType.isBaseType() && targetType.isBaseType() && (constantType == BaseTypes.IntBinding || BaseTypeBinding.isWidening(10, constantType.id)) && BaseTypeBinding.isNarrowing(targetType.id, 10)) {
            return Expression.isConstantValueRepresentable(this.constant, constantType.id, targetType.id);
        }
        return false;
    }

    public boolean isTypeReference() {
        return false;
    }

    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != ASTNode.NotAConstant) {
            return -1;
        }
        LocalVariableBinding local = this.localVariableBinding();
        if (local != null) {
            if (flowInfo.isDefinitelyNull(local)) {
                return 1;
            }
            if (flowInfo.isDefinitelyNonNull(local)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public Constant optimizedBooleanConstant() {
        return this.constant;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output);
        return this.printExpression(indent, output);
    }

    public abstract StringBuffer printExpression(int var1, StringBuffer var2);

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(";");
    }

    public void reportIllegalCast(Scope scope, TypeBinding castType, TypeBinding expressionType) {
    }

    public void resolve(BlockScope scope) {
        this.resolveType(scope);
    }

    public TypeBinding resolveType(BlockScope scope) {
        return null;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return null;
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        this.setExpectedType(expectedType);
        TypeBinding expressionType = this.resolveType(scope);
        if (expressionType == null) {
            return null;
        }
        if (expressionType == expectedType) {
            return expressionType;
        }
        if (!expressionType.isCompatibleWith(expectedType)) {
            if (scope.isBoxingCompatibleWith(expressionType, expectedType)) {
                this.computeConversion(scope, expectedType, expressionType);
            } else {
                scope.problemReporter().typeMismatchError(expressionType, expectedType, this);
                return null;
            }
        }
        return expressionType;
    }

    public void setExpectedType(TypeBinding expectedType) {
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
    }

    public void tagAsNeedCheckCast() {
    }

    public Expression toTypeReference() {
        return this;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope scope) {
    }

    public LocalVariableBinding localVariableBinding() {
        return null;
    }
}

