/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;

public class BrowserViewProperties {
    public static final String FILE_NAME = "/.ajbrowser";
    private final String VALUE_SEP = ";";
    private Properties properties = new Properties();

    public BrowserViewProperties() {
        try {
            if (new File(this.getPropertiesFilePath()).exists()) {
                this.properties.load(new FileInputStream(this.getPropertiesFilePath()));
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not read properties", ioe);
        }
    }

    public List getStructureViewOrdering() {
        return this.getPropertyValues("structureView.ordering");
    }

    public void setStructureViewOrdering(List ordering) {
        this.storeProperty("structureView.ordering", ordering);
    }

    public void setActiveAssociations(List associations) {
        this.storeProperty("structureView.associations", associations);
    }

    public void setActiveFilteredMemberKinds(List associations) {
        this.storeProperty("structureView.filtering.memberKinds", associations);
    }

    public String getActiveHierarchy() {
        return this.getProperty("structureView.hierarchy");
    }

    public void setActiveHierarchy(String hierarchy) {
        this.storeProperty("structureView.hierarchy", hierarchy);
    }

    public List getActiveVisibility() {
        return this.getPropertyValues("structureView.filtering.accessibility");
    }

    public void setActiveVisiblity(List visibility) {
        this.storeProperty("structureView.filtering.accessibility", visibility);
    }

    public List getActiveModifiers() {
        return this.getPropertyValues("structureView.filtering.modifiers");
    }

    public List getActiveFilteredMemberKinds() {
        return this.getPropertyValues("structureView.filtering.memberKinds");
    }

    public String getActiveGranularity() {
        return this.getProperty("structureView.granularity");
    }

    public void setActiveGranularity(String granularity) {
        this.storeProperty("structureView.granularity", granularity);
    }

    public void setActiveModifiers(List modifiers) {
        this.storeProperty("structureView.filtering.modifiers", modifiers);
    }

    protected String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    protected List getPropertyValues(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String valuesString = this.properties.getProperty(name);
        if (valuesString != null && !valuesString.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(valuesString, ";");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken());
            }
        }
        return values;
    }

    private void storeProperty(String name, String value) {
        this.properties.setProperty(name, value);
        this.saveProperties();
    }

    private void storeProperty(String name, List values) {
        String valuesString = "";
        Iterator it = values.iterator();
        while (it.hasNext()) {
            valuesString = valuesString + (String)it.next() + ';';
        }
        this.properties.setProperty(name, valuesString);
        this.saveProperties();
    }

    private void saveProperties() {
        try {
            this.properties.store(new FileOutputStream(this.getPropertiesFilePath()), "AJDE Settings");
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not write properties", ioe);
        }
    }

    protected String getPropertiesFilePath() {
        String path = System.getProperty("user.home");
        if (path == null) {
            path = ".";
        }
        return path + FILE_NAME;
    }
}

