/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.XPathException;

public abstract class Function
extends Expression {
    protected Expression[] argument = new Expression[6];
    private int numberOfArguments = 0;

    public void addArgument(Expression expression) {
        if (this.numberOfArguments >= this.argument.length) {
            Expression[] expressionArray = new Expression[this.argument.length * 2];
            System.arraycopy(this.argument, 0, expressionArray, 0, this.numberOfArguments);
            this.argument = expressionArray;
        }
        this.argument[this.numberOfArguments++] = expression;
    }

    public int getNumberOfArguments() {
        return this.numberOfArguments;
    }

    public abstract String getName();

    protected int checkArgumentCount(int n, int n2) throws XPathException {
        int n3 = this.numberOfArguments;
        if (n == n2 && n3 != n) {
            throw new XPathException("Function " + this.getName() + " must have " + n + this.pluralArguments(n));
        }
        if (n3 < n) {
            throw new XPathException("Function " + this.getName() + " must have at least " + n + this.pluralArguments(n));
        }
        if (n3 > n2) {
            throw new XPathException("Function " + this.getName() + " must have no more than " + n2 + this.pluralArguments(n2));
        }
        return n3;
    }

    private String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }
}

